/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.util;

import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.DevpropsError;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.modbus.VicsModbusClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flash {
    private static final Logger log = LoggerFactory.getLogger(Flash.class);
    public static final int MAX_RETRIES = 2;
    public final Program program;
    private ProgressListener listener;
    private int step;

    public Flash(Program program) {
        this.program = program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashBinaryData(ModbusClientTransport transport, int id) throws Exception {
        if (this.program == null || this.program.device == null) {
            return;
        }
        try (VicsModbusClient mc = new VicsModbusClient();){
            mc.setTransport(transport);
            this.clearApplication(mc, id);
            this.writeFlash(mc, id);
            this.writeIntEeprom(mc, id);
            this.writeNvRam(mc, id);
            this.writeExtEeprom(mc, id);
            this.rebootDevice(mc, id);
        }
    }

    public void clearApplication(VicsModbusClient mc, int id) throws Exception {
        if (mc == null) {
            this.step += 2;
            return;
        }
        log.info("Get device info");
        mc.InitReadAInputsRequest(id, 6000, 2);
        if (mc.execRequest()) {
            this.notifyStep();
            int model = mc.getResponseRegister(6000, true);
            int fw = mc.getResponseRegister(6001, true) / 100;
            log.info("Model: {}, firmware: {}", (Object)model, (Object)fw);
            if (model != this.program.device.ModelId) {
                throw new Exception("Incompatible device");
            }
            if (fw != this.program.device.Firmware) {
                throw new Exception("Incompatible firmware");
            }
            log.info("Clear application");
            mc.InitWriteRegisterRequest(id, 7000, 18546);
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
        } else {
            throw new Exception(mc.getResultAsString());
        }
        this.notifyStep();
        log.info("OK");
    }

    public void rebootDevice(VicsModbusClient mc, int id) throws Exception {
        if (mc == null) {
            ++this.step;
            return;
        }
        log.info("Reboot device");
        mc.InitWriteRegisterRequest(id, 7000, 369);
        mc.execRequest(0, true);
        this.notifyStep();
        Thread.sleep(2000L);
    }

    private int chunksCount(int bytesCount) {
        int i = bytesCount / 128;
        if (bytesCount % 128 > 0) {
            ++i;
        }
        return i;
    }

    private void writeChunk(VicsModbusClient mc, int id, byte[] data, int chunk, int startAddr, int memType, int dataSize) throws Exception {
        if (mc == null) {
            ++this.step;
            return;
        }
        int addr = chunk * 128;
        byte[] cdata = Arrays.copyOfRange(data, addr, addr + Math.min(128, dataSize - addr));
        mc.InitWriteMemRequest(id, this.program.device.ModelId, this.program.device.Firmware, memType, addr += startAddr, cdata.length, cdata);
        if (!mc.execRequest(2, false)) {
            throw new Exception(mc.getResultAsString());
        }
        this.notifyStep();
    }

    public void writeFlash(VicsModbusClient mc, int id) throws Exception {
        for (int i = 0; i < this.chunksCount(this.program.flash.length); ++i) {
            this.writeChunk(mc, id, this.program.flash, i, 0, 3, this.program.flash.length);
        }
        if (this.program.device.ModelId == 49) {
            if (mc != null) {
                mc.InitWriteMemRequest(id, this.program.device.ModelId, this.program.device.Firmware, 3, this.program.flash.length / 128 * 128, 0, new byte[0]);
                if (!mc.execRequest(2, false)) {
                    throw new Exception(mc.getResultAsString());
                }
            } else {
                ++this.step;
            }
        }
    }

    public void writeIntEeprom(VicsModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysStoreVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 1, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.eeprom.length); ++i) {
            this.writeChunk(mc, id, this.program.eeprom, i, this.program.EepromVars.startAddress & 0x3FFF, 1, this.program.eeprom.length);
        }
    }

    public void writeNvRam(VicsModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysExtVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 2, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.nvram.length); ++i) {
            this.writeChunk(mc, id, this.program.nvram, i, this.program.NvramVars.startAddress & 0x3FFF, 2, this.program.nvram.length);
        }
    }

    public void writeExtEeprom(VicsModbusClient mc, int id) throws Exception {
        if (!this.program.hasSchedule()) {
            return;
        }
        int block = 344;
        for (int i = 0; i < this.program.Schedules.items.length; ++i) {
            Schedule s = this.program.Schedules.items[i];
            if (s.var == null) continue;
            byte[] data = Arrays.copyOfRange(this.program.Schedules.eeprom, block * i, block * (i + 1));
            for (int j = 0; j < this.chunksCount(block); ++j) {
                this.writeChunk(mc, id, data, j, this.program.device.ExtEepromScheduleStart + block * i, 4, block);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWriteStepsCount() {
        int res;
        int tmp = this.step;
        this.step = 0;
        try {
            try {
                this.clearApplication(null, 0);
                this.writeFlash(null, 0);
                this.writeIntEeprom(null, 0);
                this.writeNvRam(null, 0);
                this.writeExtEeprom(null, 0);
                this.rebootDevice(null, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            res = this.step;
            this.step = tmp;
        }
        return res;
    }

    public int getReadStepsCount() {
        return 10;
    }

    public void registerProgListener(ProgressListener listener) {
        this.listener = listener;
    }

    public int initWriteProgress() {
        return this.getWriteStepsCount();
    }

    public int initReadProgress() {
        return this.getReadStepsCount();
    }

    private void notifyStep() {
        ++this.step;
        if (this.listener != null) {
            this.listener.updateStep(this.step);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block15: {
            try {
                if (args.length < 4) {
                    System.out.println("Command line parameters: RTU|TCP|RTUoverTCP <COM_port:baud:N|O|E:stop>|<IP_address:port> <id> <filename>");
                    return;
                }
                Program prg = Flash.loadVicsFile(args[3]);
                if (prg == null) {
                    return;
                }
                Flash flash = new Flash(prg);
                ModbusClientTransport transport = null;
                String type = args[0];
                String[] comm = args[1].split(":");
                if ("RTU".equalsIgnoreCase(type)) {
                    transport = new RtuTransportJSerialComm(comm[0], Integer.parseInt(comm[1]), 8, "O".equalsIgnoreCase(comm[2]) ? 1 : ("E".equalsIgnoreCase(comm[2]) ? 2 : 0), Integer.parseInt(comm[3]), 10000, 100);
                } else if ("TCP".equalsIgnoreCase(type)) {
                    transport = new TcpTransport(comm[0], Integer.parseInt(comm[1]), null, 0, 10000, 10000, 100, true);
                } else if ("RTUoverTCP".equalsIgnoreCase(type)) {
                    transport = new RtuOverTcpTransport(comm[0], Integer.parseInt(comm[1]), null, 0, 10000, 10000, 100, true);
                } else {
                    throw new Exception("Unknown transport: " + type);
                }
                int id = Integer.parseInt(args[2]);
                flash.registerProgListener(new ProgressListener(){

                    @Override
                    public void updateStep(int step) {
                        System.out.print(".");
                    }
                });
                System.out.println();
                System.out.println(prg.device.Name + ", program: " + prg.getProgId() + ", modbus id: " + id);
                System.out.println("transport: " + transport);
                if (args.length >= 5 && "read".equalsIgnoreCase(args[4])) break block15;
                try (VicsModbusClient mc = new VicsModbusClient();){
                    mc.setTransport(transport);
                    System.out.println();
                    System.out.println("Clear application");
                    flash.clearApplication(mc, id);
                    System.out.println();
                    System.out.println("Write FLASH");
                    flash.writeFlash(mc, id);
                    System.out.println();
                    System.out.println("Write EEPROM");
                    flash.writeIntEeprom(mc, id);
                    System.out.println();
                    System.out.println("Write NVRAM");
                    flash.writeNvRam(mc, id);
                    System.out.println();
                    System.out.println("Write External EEPROM");
                    flash.writeExtEeprom(mc, id);
                    System.out.println();
                    System.out.println("Reboot device");
                    flash.rebootDevice(mc, id);
                    System.out.println();
                    System.out.println("OK");
                }
            }
            catch (NoSuchFileException e) {
                System.out.println("");
                System.out.println("ERROR. File not found: " + e.getMessage());
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR (" + e.getClass().getName() + "): " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") != null) {
                    e.printStackTrace();
                }
                log.error("EXCEPTION", e);
            }
        }
    }

    private static Program loadVicsFile(String filePath) throws IOException, ErrorInFile, DevpropsError, SyntaxError, CompilerError {
        Program prg = new Program();
        File file = new File(filePath);
        prg.loadFromFile(file.getAbsolutePath(), true);
        prg.makeBinaryData();
        if (prg.fileVersion < 600) {
            System.out.println("Incompatible ViCS version");
            return null;
        }
        return prg;
    }

    public static interface ProgressListener {
        public void updateStep(int var1);
    }
}

