/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.util;

import certa.vics.Utils;
import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.Argument;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.Device;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuItemVariable;
import certa.vics.compiler.MenuString;
import certa.vics.compiler.ModbusMasterProfile;
import certa.vics.compiler.ModbusMasterRequest;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.Port;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ExportSource {
    private ExportSource() {
    }

    public static void printSource(Program program, PrintWriter out, boolean fbd) throws CompilerError {
        int i;
        out.println("# Memory usage (bytes)");
        out.println("#   RAM:     " + program.getRamSize() + ",   (max: " + program.device.RamSize + ")");
        out.println("#   EEPROM:  " + program.getEepromSize() + ",   (max: " + program.device.EepromSize + ")");
        out.println("#   NVRAM:   " + program.getNvramSize() + ",   (max: " + program.device.NvramSize + ")");
        out.println("#   FLASH:   " + program.getFlashSize() + ",   (max: " + program.device.FlashSize + ")");
        out.println("#     Code:           " + program.getAllCodeSize());
        out.println("#     RAM init:       " + program.getRamInitSize());
        out.println("#     Constants:      " + program.getConstantsSize());
        out.println("#     HMI vars:       " + program.getHmiVarsSize());
        out.println("#     Menu:           " + program.getMenuSize());
        out.println("#     Comm. profiles: " + program.getAllCommProfilesSize());
        out.println();
        out.println("FileVersion 600");
        out.println("ID " + program.getEncodedId());
        out.println("CodeCRC " + program.codeCrc);
        out.println("Target " + program.device.PropsFile);
        out.println();
        ExportSource.printVars(program.device.SysOutVars, out, true, false);
        out.println();
        ExportSource.printVars(program.device.SysStoreVars, out, true, false);
        out.println();
        ExportSource.printVars(program.device.SysExtVars, out, true, false);
        out.println();
        if (!fbd) {
            out.println();
            ExportSource.printVars(program.Constants, out, false, false);
            out.println();
            ExportSource.printVars(program.RamVars, out, false, true);
            out.println();
            ExportSource.printVars(program.NvramVars, out, false, false);
            out.println();
            ExportSource.printVars(program.EepromVars, out, false, false);
            out.println();
        }
        for (i = 0; i < program.slaveProfiles.length; ++i) {
            ExportSource.printModbusSlave(program.slaveProfiles[i], out);
            out.println();
        }
        for (i = 0; i < program.rs485Ports.length; ++i) {
            ExportSource.printPort("RS485 " + (i + 1), program.rs485Ports[i], out);
            out.println();
        }
        for (i = 0; i < program.tcpSlavePorts.length; ++i) {
            ExportSource.printPort("TCP " + (i + 1), program.tcpSlavePorts[i], out);
            out.println();
        }
        if (program.usbPort != null) {
            ExportSource.printPort("USB", program.usbPort, out);
            out.println();
        }
        if (program.hasSchedule()) {
            ExportSource.printSchedules(program, out);
            out.println();
        }
        ExportSource.printMenu(program, out, "", program.mainMenu);
        if (!fbd) {
            if (program.codeSource.size() > 0) {
                for (String s : program.codeSource) {
                    out.println(s);
                }
            } else {
                ExportSource.printCodeBlock(program.MainCode, program.device, out);
                ExportSource.printSubs(program, out);
            }
        }
        out.println("End");
        out.println(program.extraData);
    }

    private static void printVars(VariablesBlock vd, PrintWriter out, boolean sysInit, boolean allowAlarms) {
        out.println(vd.name);
        for (Variable v : vd.map.values()) {
            String comment;
            if (v.hidden) continue;
            String init = "";
            if (v.hasInitValue()) {
                init = " = ";
                init = v.type == 3 ? init + Utils.numToString(v.initValue) : init + Utils.Round(v.initValue);
                if (v.arrayItems != null) {
                    for (int i = 1; i < v.arrayItems.length; ++i) {
                        Variable v1 = v.arrayItems[i];
                        init = v1.type == 3 ? init + " " + Utils.numToString(v1.initValue) : init + " " + Utils.Round(v1.initValue);
                    }
                }
            } else if (sysInit) continue;
            String string = comment = !Utils.strEmpty(v.comment) && !sysInit ? " # " + v.comment : "";
            if (v.arrayItems != null) {
                out.println("  " + Variable.typeToString(v.type) + "." + v.arrayName() + "{" + v.arrayItems.length + "}" + init + comment);
                continue;
            }
            out.println("  " + (allowAlarms && v.alarm ? "A " : "") + Variable.typeToString(v.type) + "." + v.name + init + comment);
        }
        out.println("End" + vd.name);
    }

    private static String mbVar(Variable var) {
        if (var != null) {
            return var.fullName();
        }
        return "0";
    }

    private static void printPort(String name, Port port, PrintWriter out) {
        if (port.type == Port.PortType.RS485 && port.isRs485Master) {
            out.println("Port " + name + (port.isRs485TcpGateway ? " TCPGW" : " NoTCPGW"));
            ModbusMasterProfile mb = port.masterProfile;
            out.println("  MASTER " + mb.timeout + " " + mb.pause + " " + mb.vxModules);
            for (int i = 0; i < mb.requests.size(); ++i) {
                ModbusMasterRequest rq = mb.requests.get(i);
                out.println("  REQUEST " + rq.func + " " + rq.id + " " + rq.addr + " " + ExportSource.mbVar(rq.varCmd) + " " + ExportSource.mbVar(rq.varResult) + " " + ExportSource.mbVar(rq.varErrCount));
                for (int j = 0; j < rq.registers.size(); ++j) {
                    ModbusReg r = rq.registers.get(j);
                    if (r.var != null) {
                        String k = "";
                        if (r.var.type == 3) {
                            k = " $ " + r.digits;
                        }
                        out.println("    " + r.var.fullName() + k);
                        continue;
                    }
                    out.println("    0");
                }
            }
        } else {
            out.println("Port " + name);
            String tgw = "";
            if (port.type == Port.PortType.RS485) {
                tgw = " " + (port.gatewayTargetRS485index + 1);
            }
            if (port.slaveProfile != null) {
                out.println("  SLAVE " + (port.slaveProfile.index + 1) + tgw);
            } else {
                out.println("  SLAVE 0");
            }
        }
        out.println("EndPort");
    }

    private static void printModbusSlave(ModbusSlaveProfile profile, PrintWriter out) {
        out.println("ModbusSlave " + (profile.index + 1));
        ExportSource.printMbSlaveRegs(profile, profile.Inputs, "input", out);
        ExportSource.printMbSlaveRegs(profile, profile.Coils, "coil", out);
        ExportSource.printMbSlaveRegs(profile, profile.IRs, "ir", out);
        ExportSource.printMbSlaveRegs(profile, profile.HRs, "hr", out);
        out.println("EndModbusSlave");
    }

    private static void printMbSlaveRegs(ModbusSlaveProfile block, ArrayList<ModbusReg> list, String prefix, PrintWriter out) {
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            if (!block.isEmpty(r)) {
                String k = "";
                if (r.var.type == 3) {
                    k = " $ " + r.digits;
                }
                out.println("  " + prefix + i + " " + r.var.fullName() + k);
                continue;
            }
            out.println("  " + prefix + i + " 0");
        }
    }

    private static void printCodeBlock(CodeBlock cb, Device device, PrintWriter out) {
        out.println(cb.Name);
        ExportSource.printCode(cb, device, out);
        out.println("End" + cb.Name);
    }

    private static void printSubs(Program program, PrintWriter out) {
        for (CodeBlock cb : program.Subs.values()) {
            out.println("Sub " + cb.Name);
            ExportSource.printCode(cb, program.device, out);
            out.println("EndSub");
        }
    }

    private static void printCode(CodeBlock cb, Device device, PrintWriter out) {
        for (Command ci : cb.Items) {
            for (String lbl : cb.Labels.keySet()) {
                if (cb.Labels.get(lbl) != ci.offset) continue;
                out.println(":" + lbl);
            }
            String s = "  " + ci.cmdDef.Name;
            if (ci.cmdDef == device.CommandMap.get("END") || ci.cmdDef == device.CommandMap.get("ENDI") || ci.cmdDef == device.CommandMap.get("RET")) {
                s = "#" + s;
            }
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    s = s + " " + (Integer)arg.Value;
                    continue;
                }
                if (arg.Type == 5) continue;
                if (arg.Type == 2) {
                    if (arg.def.IsArray) {
                        s = s + " " + ((Variable)arg.Value).fullArrayName();
                        continue;
                    }
                    s = s + " " + ((Variable)arg.Value).fullName();
                    continue;
                }
                s = s + " " + (String)arg.Value;
            }
            out.println(s);
        }
    }

    private static void printSchedules(Program program, PrintWriter out) {
        for (Schedule s : program.Schedules.items) {
            if (s == null) continue;
            out.println("Schedule " + s.number);
            out.println("  strict " + (s.strict ? "1" : "0"));
            if (s.var != null) {
                out.println("  var " + s.var.fullName());
                if (s.var.type == 3) {
                    out.println("  digits " + Integer.toString(s.digits));
                }
                if (s.var.type == 3 || s.var.type == 2) {
                    out.println("  min " + Utils.FormatDouble(s.min, s.digits));
                    out.println("  max " + Utils.FormatDouble(s.max, s.digits));
                }
            }
            if (s.enabled != null) {
                out.println("  enable " + s.enabled.fullName());
            }
            for (int i = 0; i < 7; ++i) {
                String ts = s.encodeArray(i);
                if (Utils.strEmpty(ts)) continue;
                out.println("  day" + (i + 1) + " " + ts);
            }
            out.println("EndSchedule");
        }
    }

    private static String visibilityVar(AMenuItem mi) {
        Variable v = mi.getVisibleVar();
        if (v != null) {
            return v.fullName() + " ";
        }
        return "";
    }

    private static void printMenu(Program program, PrintWriter out, String tab, MenuItemMenu menu) {
        if (Utils.strEmpty(tab)) {
            out.println("RootMenu");
        } else {
            out.println(tab + "Menu " + ExportSource.visibilityVar(menu) + menu.getAccess() + " " + MenuString.makeSaveable(menu.getName()));
        }
        for (AMenuItem mi : menu.items) {
            if (mi instanceof MenuItemMenu) {
                ExportSource.printMenu(program, out, tab + "  ", (MenuItemMenu)mi);
                continue;
            }
            if (!(mi instanceof MenuItemVariable)) continue;
            MenuItemVariable vmi = (MenuItemVariable)mi;
            out.print(tab + "  " + (vmi.isText ? "VarText " : "VarNum ") + ExportSource.visibilityVar(mi) + vmi.getAccess() + " " + MenuString.makeSaveable(vmi.getName()) + " " + vmi.getVariable().fullName() + (vmi.isWritable() ? " w " : " r "));
            if (vmi.isText) {
                out.println(vmi.saveStrings());
                continue;
            }
            out.println(vmi.getNumDigits() + " " + (vmi.isWritable() ? vmi.getNumMin() + " " + vmi.getNumMax() : ""));
        }
        if (Utils.strEmpty(tab)) {
            out.println("EndRootMenu\n");
        } else {
            out.println(tab + "EndMenu");
        }
    }

    public static void main(String[] args) {
        block3: {
            try {
                if (args.length == 0) {
                    System.out.println("Source file name is absent");
                    return;
                }
                Program p = new Program();
                p.loadFromFile(args[0], true);
                ExportSource.printSource(p, new PrintWriter(System.out, true), false);
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR: " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") == null) break block3;
                e.printStackTrace();
            }
        }
    }
}

