/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.compiler.Variable;
import certa.vics.ide.variables.VariableDef;

public class VariableRef {
    public final VariableDef varDef;
    public final int indexInArray;

    public VariableRef(VariableDef varDef, int indexInArray) {
        this.varDef = varDef;
        this.indexInArray = indexInArray;
    }

    public int type() {
        if (this.varDef.getArraySize() > 0 && this.indexInArray < 0) {
            return 2;
        }
        return this.varDef.getValueType();
    }

    public int arraySize() {
        if (this.indexInArray == 0) {
            return this.varDef.getArraySize();
        }
        return 0;
    }

    public boolean isArray() {
        return this.varDef.getArraySize() > 0 && this.indexInArray == 0;
    }

    public boolean isSizeOfArray() {
        return this.varDef.getArraySize() > 0 && this.indexInArray < 0;
    }

    public boolean isWritable() {
        if (this.isSizeOfArray()) {
            return false;
        }
        return this.varDef.isWritable();
    }

    public boolean isWritableInFbd() {
        if (this.isSizeOfArray()) {
            return false;
        }
        return this.varDef.isWritableInFbd();
    }

    private String arraySuffix() {
        if (this.varDef.getArraySize() > 0) {
            if (this.indexInArray >= 0) {
                return "[" + Integer.toString(this.indexInArray) + "]";
            }
            return ".size";
        }
        return "";
    }

    public String fullName() {
        return this.varDef.getFullName() + this.arraySuffix();
    }

    public String shortName() {
        return this.varDef.getName() + this.arraySuffix();
    }

    public Variable getCompiledVar() {
        int size = this.varDef.getArraySize();
        Variable var = this.varDef.compiledVar;
        if (size > 0) {
            if (this.indexInArray < 0) {
                return var.arraySizeVar;
            }
            if (this.indexInArray < size) {
                return var.arrayItems[this.indexInArray];
            }
            throw new IndexOutOfBoundsException("Invalid index in array");
        }
        return var;
    }

    public String toString() {
        String s = this.varDef.getArraySize() > 0 && this.indexInArray == 0 ? this.shortName() + " (array: " + this.varDef.getArraySize() + ")" : this.shortName();
        return s;
    }

    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof VariableRef) {
            VariableRef vr2 = (VariableRef)object2;
            return this.varDef == vr2.varDef && this.indexInArray == vr2.indexInArray;
        }
        return false;
    }

    public static boolean sameVar(VariableRef v1, VariableRef v2) {
        if (v1 != null) {
            return v1.equals(v2);
        }
        return v2 == null;
    }

    public double getInitValue() {
        if (this.indexInArray >= 0) {
            return this.varDef.getInitValuesArray().get(this.indexInArray);
        }
        return this.varDef.getArraySize();
    }
}

