/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ArrayEditDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static ArrayEditDialog dialog;
    public static final int COL_INDEX = 0;
    public static final int COL_VALUE = 1;
    public static final String[] COLUMNS;
    boolean okPressed;
    JButton btnOk;
    JPanel pnlParams;
    JCheckBox chkEmpty;
    JTable table;
    ArrayTableModel model;
    boolean isEmpty;
    ArrayList<Double> array = new ArrayList();
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayEditDialog.this.isEmpty = ArrayEditDialog.this.chkEmpty.isSelected();
            ArrayEditDialog.this.table.setEnabled(!ArrayEditDialog.this.isEmpty);
        }
    };

    public static boolean showDialog(ArrayList<Double> array) {
        if (dialog == null) {
            dialog = new ArrayEditDialog(MainFrame.instance);
        }
        ArrayEditDialog.dialog.table.requestFocusInWindow();
        ArrayEditDialog.dialog.okPressed = false;
        dialog.setControls(array);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (ArrayEditDialog.dialog.okPressed) {
            dialog.updateArray(array);
            return true;
        }
        return false;
    }

    public ArrayEditDialog(JFrame parent) {
        super(parent, "\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.model = new ArrayTableModel();
        this.table = new JTable(this.model);
        this.chkEmpty = new JCheckBox("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043d\u0443\u043b\u044f\u043c\u0438");
        this.chkEmpty.addActionListener(this.update);
        this.setupTable();
        pnlContents.add((Component)this.chkEmpty, "alignx center, wrap");
        pnlContents.add((Component)new JScrollPane(this.table), "");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(50);
        cm.getColumn(0).setCellRenderer(new IdeTableCellRenderer(0, 8));
        cm.getColumn(1).setCellRenderer(new IdeTableCellRenderer(2, 8));
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 300));
    }

    void setControls(ArrayList<Double> array) {
        this.array = new ArrayList<Double>(array);
        this.isEmpty = array.get(0).isNaN();
        for (int i = 0; i < this.array.size(); ++i) {
            if (!this.array.get(i).isNaN()) continue;
            this.array.set(i, 0.0);
        }
        this.chkEmpty.setSelected(this.isEmpty);
        this.update.actionPerformed(null);
    }

    void updateArray(ArrayList<Double> array) {
        if (this.isEmpty) {
            for (int i = 0; i < array.size(); ++i) {
                array.set(i, Double.NaN);
            }
        } else {
            array.clear();
            array.addAll(this.array);
        }
    }

    static {
        COLUMNS = new String[]{"\u0418\u043d\u0434\u0435\u043a\u0441", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"};
    }

    class ArrayTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        ArrayTableModel() {
        }

        @Override
        public int getRowCount() {
            return ArrayEditDialog.this.array.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return Double.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && !ArrayEditDialog.this.isEmpty;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                ArrayEditDialog.this.array.set(rowIndex, (Double)aValue);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return rowIndex;
            }
            if (columnIndex == 1) {
                return ArrayEditDialog.this.isEmpty ? Double.valueOf(0.0) : ArrayEditDialog.this.array.get(rowIndex);
            }
            return null;
        }
    }
}

