/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.UiEditor;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class UiStringsTableModel
implements TableModel {
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    final UiEditor editor;

    UiStringsTableModel(UiEditor editor) {
        this.editor = editor;
    }

    @Override
    public int getRowCount() {
        if (this.editor.focusedVarItem != null) {
            return this.editor.focusedVarItem.textStrings.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435";
            }
            case 1: {
                return "\u0422\u0435\u043a\u0441\u0442";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return Integer.toString(rowIndex);
        }
        if (columnIndex == 1 && this.editor.focusedVarItem != null && rowIndex < this.editor.focusedVarItem.textStrings.size()) {
            return this.editor.focusedVarItem.textStrings.get(rowIndex);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1 && this.editor.focusedVarItem != null && rowIndex < this.editor.focusedVarItem.textStrings.size()) {
            this.editor.focusedVarItem.setString(rowIndex, (String)aValue);
            this.fireTableChanged();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableChanged() {
        TableModelEvent e = new TableModelEvent(this);
        for (TableModelListener tml : this.listeners) {
            tml.tableChanged(e);
        }
    }
}

