/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.HistoryItem;
import java.util.ArrayDeque;
import java.util.Deque;

public class EditorHistory {
    private Deque<HistoryItem> undoStack = new ArrayDeque<HistoryItem>();
    private Deque<HistoryItem> redoStack = new ArrayDeque<HistoryItem>();
    private HistoryItem savedToDiskState;

    public boolean save(HistoryItem item) {
        return true;
    }

    public void markSavedToDisk() {
        this.savedToDiskState = this.undoStack.peekFirst();
    }

    public boolean isSavedToDisk() {
        return this.savedToDiskState == this.undoStack.peekFirst();
    }

    public void clear(HistoryItem initState) {
        this.undoStack.clear();
        this.redoStack.clear();
        this.savedToDiskState = null;
        this.undoStack.addFirst(initState);
    }

    public boolean canUndo() {
        return this.undoStack.size() > 1;
    }

    public boolean canRedo() {
        return this.redoStack.size() > 0;
    }

    public HistoryItem undo() {
        if (this.undoStack.size() < 2) {
            return null;
        }
        this.redoStack.addFirst(this.undoStack.removeFirst());
        return this.undoStack.peekFirst();
    }

    public HistoryItem redo() {
        if (this.redoStack.size() < 1) {
            return null;
        }
        HistoryItem item = this.redoStack.removeFirst();
        this.undoStack.addFirst(item);
        return item;
    }
}

