/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.Variable;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.MenuItemMenuView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class AMenuItemView {
    public final UiEditor editor;
    private MenuItemMenuView parent;
    private int access;
    private String name;
    private VariableRef visibleVar;
    static final int MAX_ACCESS = 3;
    static final String JSON_CLASS = "class";
    static final String JSON_NAME = "name";
    static final String JSON_ACCESS = "access";
    static final String JSON_VISIBLE = "visible";

    public AMenuItemView(UiEditor editor, MenuItemMenuView parent, VariableRef visibleVar, int access, String name) {
        this.editor = editor;
        this.parent = parent;
        this.visibleVar = visibleVar;
        this.access = access;
        this.name = name;
        if (parent != null) {
            parent.getItems().add(this);
        }
    }

    public static VariableRef makeVarRef(Variable var) {
        return MainFrame.instance.getVarsEditor().makeRef(var);
    }

    public String accessString() {
        switch (this.access) {
            case 1: {
                return "USER";
            }
            case 2: {
                return "SERVICE";
            }
            case 3: {
                return "DEVELOPER";
            }
        }
        return "";
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        if (this.access != access) {
            this.editor.markModified();
        }
        this.access = access;
    }

    public VariableRef getVisibleVar() {
        return this.visibleVar;
    }

    public void setVisibleVar(VariableRef var) {
        if (this.visibleVar != var) {
            this.editor.markModified();
        }
        this.visibleVar = var;
    }

    public void setParent(MenuItemMenuView parent) {
        if (this.parent != parent) {
            this.editor.markModified();
        }
        this.parent = parent;
    }

    public Object[] getPath() {
        AMenuItemView item;
        int depth = 0;
        for (item = this; item != null; item = item.getParent()) {
            ++depth;
        }
        Object[] res = new Object[depth];
        int i = 0;
        for (item = this; item != null; item = item.getParent()) {
            res[depth - ++i] = item;
        }
        return res;
    }

    public String toString() {
        String s = this.access > 0 ? "    *" + this.accessString() + "*" : "";
        return this.name + s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != name) {
            this.editor.markModified();
        }
        this.name = name;
    }

    public MenuItemMenuView getParent() {
        return this.parent;
    }

    public String getTipText() {
        return null;
    }

    protected void saveVar(VariableRef vr, String key, JSONObject jso, ArrayList<VariableDef> vars) {
        if (vr != null) {
            jso.put(key, vr.fullName());
            if (vars != null) {
                vars.add(vr.varDef);
            }
        }
    }

    public void saveToJSON(JSONObject jso, ArrayList<VariableDef> vars) {
        jso.put(JSON_CLASS, this.getClass().getSimpleName());
        jso.put(JSON_NAME, this.name);
        jso.put(JSON_ACCESS, this.access);
        this.saveVar(this.visibleVar, JSON_VISIBLE, jso, vars);
    }

    protected VariableRef loadVar(String key, JSONObject jso) {
        String s = jso.optString(key);
        if (!Utils.strEmpty(s)) {
            return this.editor.mainFrame.getVarsEditor().locateVar(s);
        }
        return null;
    }

    public void loadFromJSON(JSONObject jso) {
        this.name = jso.optString(JSON_NAME);
        this.access = jso.optInt(JSON_ACCESS, 0);
        if (this.access < 0) {
            this.access = 0;
        }
        if (this.access >= 3) {
            this.access = 3;
        }
        this.visibleVar = this.loadVar(JSON_VISIBLE, jso);
    }

    public void updateVarRefs() {
        if (this.visibleVar != null) {
            this.visibleVar.varDef.addMenuRef(this, false);
        }
    }
}

