/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.Port;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusSlaveEditor;
import certa.vics.ide.ports.PortsEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class UsbSlaveParamsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final PortsEditor editor;
    final Port port;
    JComboBox<String> cbxSlaveProfile;
    boolean isModified;
    boolean inUpdate = false;

    private void updateSlaveProfile() {
        if (this.inUpdate) {
            return;
        }
        int index = this.cbxSlaveProfile.getSelectedIndex();
        ModbusSlaveProfile p = null;
        if (index >= 0) {
            p = this.editor.mainFrame.program.slaveProfiles[index];
        }
        if (p != this.port.slaveProfile) {
            this.port.slaveProfile = p;
            this.markModified();
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    public UsbSlaveParamsPanel(PortsEditor editor, Port port) {
        this.editor = editor;
        this.port = port;
        this.cbxSlaveProfile = new JComboBox<String>(new DefaultComboBoxModel<String>(ModbusSlaveEditor.PROFILES));
        this.cbxSlaveProfile.setFocusable(false);
        this.cbxSlaveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsbSlaveParamsPanel.this.updateSlaveProfile();
            }
        });
        this.setLayout(new MigLayout(""));
        this.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b MODBUS:"), "");
        this.add(this.cbxSlaveProfile, "wrap");
        this.add((Component)new JLabel("<html>\u041f\u0440\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430 \u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u043f\u043e USB, \u043d\u0430 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0435 \u043f\u043e\u044f\u0432\u0438\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 COM-\u043f\u043e\u0440\u0442 (USB Serial).<br>\u0412 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435, \u043e\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e\u0449\u0435\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0447\u0435\u0440\u0435\u0437 USB-\u043f\u043e\u0440\u0442, \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043b\u044e\u0431\u0443\u044e \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0438 \u043b\u044e\u0431\u043e\u0439 Slave_ID.<br>\u0427\u0435\u0440\u0435\u0437 \u043f\u043e\u0440\u0442 USB \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u044b \u0441 \u043b\u044e\u0431\u044b\u043c Slave_ID \u0438 \u043b\u044e\u0431\u043e\u0439 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c\u044e.</html>"), "spanx");
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(Program prg) {
        this.inUpdate = true;
        try {
            int index = -1;
            for (int i = 0; i < prg.slaveProfiles.length; ++i) {
                if (prg.slaveProfiles[i] != this.port.slaveProfile) continue;
                index = i;
                break;
            }
            this.cbxSlaveProfile.setSelectedIndex(index);
        }
        finally {
            this.inUpdate = false;
        }
    }

    public void compileData(Schedule sch, Program prg) throws SyntaxError {
    }
}

