/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.Port;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusSlaveEditor;
import certa.vics.ide.ports.PortsEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Rs485SlaveParamsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final PortsEditor editor;
    final Port port;
    JComboBox<String> cbxSlaveProfile;
    JCheckBox cbRedirect;
    JPanel pnlRedirect;
    JComboBox<Port> cbxRedirectTarget;
    boolean isModified;
    boolean inUpdate = false;

    public Rs485SlaveParamsPanel(PortsEditor editor, Port port, int portIndex) {
        this.editor = editor;
        this.port = port;
        this.cbxSlaveProfile = new JComboBox<String>(new DefaultComboBoxModel<String>(ModbusSlaveEditor.PROFILES));
        this.cbxSlaveProfile.setFocusable(false);
        this.cbxSlaveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rs485SlaveParamsPanel.this.updateSlaveProfile();
            }
        });
        this.cbRedirect = new JCheckBox("<html>\u041f\u0435\u0440\u0435\u0441\u044b\u043b\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u044b \u0447\u0435\u0440\u0435\u0437 \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043e\u0440\u0442 (master),<br>\u0435\u0441\u043b\u0438 Slave_ID \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c RS485_" + (portIndex + 1) + "_Slave_ID</html>");
        this.cbRedirect.setFocusable(false);
        this.cbRedirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rs485SlaveParamsPanel.this.updateRedirectCheck();
            }
        });
        this.cbxRedirectTarget = new JComboBox();
        this.cbxRedirectTarget.setFocusable(false);
        this.cbxRedirectTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rs485SlaveParamsPanel.this.updateRedirectList();
            }
        });
        this.setLayout(new MigLayout(""));
        this.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b MODBUS:"), "");
        this.add(this.cbxSlaveProfile, "wrap");
        this.add((Component)this.cbRedirect, "spanx, wrap");
        this.pnlRedirect = new JPanel(new MigLayout(""));
        this.pnlRedirect.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u0441\u044b\u043b\u0430\u0442\u044c \u0447\u0435\u0440\u0435\u0437"), "");
        this.pnlRedirect.add(this.cbxRedirectTarget, "");
        this.add((Component)this.pnlRedirect, "spanx, hidemode 3, gap 0px 0px");
    }

    private void updateSlaveProfile() {
        if (this.inUpdate) {
            return;
        }
        int index = this.cbxSlaveProfile.getSelectedIndex();
        ModbusSlaveProfile p = null;
        if (index >= 0) {
            p = this.editor.mainFrame.program.slaveProfiles[index];
        }
        if (p != this.port.slaveProfile) {
            this.port.slaveProfile = p;
            this.markModified();
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    private void updateRedirectCheck() {
        if (this.inUpdate) {
            return;
        }
        boolean redirect = this.cbRedirect.isSelected();
        this.pnlRedirect.setVisible(redirect);
        if (this.port.gatewayTargetRS485index >= 0 && !redirect) {
            this.markModified();
            this.port.gatewayTargetRS485index = -1;
            this.editor.reloadPorts(this.port);
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    private void updateRedirectList() {
        int ri;
        if (this.inUpdate) {
            return;
        }
        Port target = (Port)this.cbxRedirectTarget.getSelectedItem();
        int n = ri = target != null ? target.index : -1;
        if (ri != this.port.gatewayTargetRS485index) {
            this.markModified();
            this.port.gatewayTargetRS485index = ri;
            this.editor.reloadPorts(this.port);
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(Program prg) {
        this.inUpdate = true;
        try {
            int index = -1;
            for (int i = 0; i < prg.slaveProfiles.length; ++i) {
                if (prg.slaveProfiles[i] != this.port.slaveProfile) continue;
                index = i;
                break;
            }
            this.cbxSlaveProfile.setSelectedIndex(index);
            Port target = null;
            int ri = this.port.gatewayTargetRS485index;
            if (ri >= 0 && prg.rs485Ports[ri].isRs485Master) {
                target = prg.rs485Ports[ri];
            }
            this.cbRedirect.setSelected(target != null);
            this.pnlRedirect.setVisible(target != null);
            Vector<Port> vector = new Vector<Port>();
            vector.add(null);
            for (int i = 0; i < prg.rs485Ports.length; ++i) {
                Port p = prg.rs485Ports[i];
                if (p == this.port || !p.isRs485Master) continue;
                vector.add(p);
            }
            this.cbxRedirectTarget.setModel(new DefaultComboBoxModel(vector));
            this.cbxRedirectTarget.setSelectedItem(target);
        }
        finally {
            this.inUpdate = false;
        }
    }

    public void compileData(Schedule sch, Program prg) throws SyntaxError {
    }
}

