/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.ide.modbus.RegView;
import certa.vics.ide.variables.VariableRef;
import java.util.ArrayList;

public class RequestView {
    public int function;
    public int id;
    public int address;
    public VariableRef varCmd;
    public VariableRef varResult;
    public VariableRef varErrorCounter;
    final ArrayList<RegView> regs = new ArrayList();

    public RequestView(int function, int id, int addr, VariableRef varCmd, VariableRef varResult, VariableRef varErrorCounter) {
        this.varCmd = varCmd;
        this.varResult = varResult;
        this.varErrorCounter = varErrorCounter;
        this.function = function;
        this.id = id;
        this.address = addr;
    }

    public boolean isDiscrete() {
        return this.function == 1 || this.function == 2 || this.function == 5 || this.function == 15;
    }

    public boolean varsWritable() {
        return this.function == 1 || this.function == 2 || this.function == 3 || this.function == 4;
    }

    public static boolean correctId(int id) {
        return id >= 0 && id <= 255;
    }

    public static boolean correctAddress(int addr, int size) {
        return addr >= 0 && addr + size <= 65536;
    }

    public static boolean correctSize(int size, int func) {
        if (func == 1 || func == 2 || func == 15) {
            return size >= 0 && size <= 256;
        }
        if (func == 3 || func == 4 || func == 16) {
            return size >= 0 && size <= 125;
        }
        if (func == 5 || func == 6) {
            return size == 0 || size == 1;
        }
        return false;
    }

    public boolean isCorrect() {
        int s = this.regs.size();
        return RequestView.correctId(this.id) && RequestView.correctAddress(this.address, s) && RequestView.correctSize(s, this.function);
    }

    public String toString() {
        if (this.isCorrect()) {
            return "ID: " + this.id + ", fn: " + this.function + ", addr: " + (this.regs.size() == 0 ? "----" : this.address + (this.regs.size() > 1 ? "..." + (this.address + this.regs.size() - 1) : ""));
        }
        return "--- \u041e\u0428\u0418\u0411\u041a\u0410! ---";
    }
}

