/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.compiler.Port;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ports.APortView;
import certa.vics.ide.ports.EthernetPortView;
import certa.vics.ide.ports.PortsActions;
import certa.vics.ide.ports.Rs485PortView;
import certa.vics.ide.ports.UsbPortView;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONObject;

public class PortsEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    static final APortView[] EMPTY_TABS = new APortView[0];
    PortsActions actions;
    final MainFrame mainFrame;
    JTabbedPane tabbedPane;
    private APortView[] tabs = EMPTY_TABS;

    public PortsEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u043e\u0440\u0442\u043e\u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430", false);
        this.mainFrame = mainFrame;
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PortsEditor.this.initFocus();
            }
        });
        this.tabbedPane.addMouseListener(this.focuser);
        this.loadProps();
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new PortsActions(this);
        return this.actions;
    }

    @Override
    public void initFocus() {
        APortView t;
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= 0 && (t = this.tabs[i]) != null) {
            t.updateVarList();
        }
    }

    @Override
    public void clear() {
        this.tabbedPane.removeAll();
        this.tabs = EMPTY_TABS;
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        for (APortView t : this.tabs) {
            t.isModified = false;
        }
    }

    private void loadData() {
        Program prg = this.mainFrame.program;
        this.tabs = new APortView[prg.rs485Ports.length + (prg.tcpSlavePorts.length > 0 ? 1 : 0) + (prg.usbPort != null ? 1 : 0)];
        for (int i = 0; i < prg.rs485Ports.length; ++i) {
            Rs485PortView t = new Rs485PortView(this, "RS485_" + (i + 1), prg.rs485Ports[i], i);
            this.tabbedPane.addTab(t.getTitle(), null, t, null);
            this.tabs[i] = t;
        }
        if (prg.tcpSlavePorts.length > 0) {
            EthernetPortView t = new EthernetPortView(this, "Ethernet", prg.tcpSlavePorts);
            this.tabbedPane.addTab(t.getTitle(), null, t, null);
            this.tabs[prg.rs485Ports.length] = t;
        }
        if (prg.usbPort != null) {
            UsbPortView t = new UsbPortView(this, "USB", prg.usbPort);
            this.tabbedPane.addTab(t.getTitle(), null, t, null);
            this.tabs[this.tabs.length - 1] = t;
        }
        this.reloadPorts(null);
    }

    void reloadPorts(Port portToSkip) {
        for (APortView p : this.tabs) {
            p.loadData(portToSkip);
        }
    }

    @Override
    public void initNewProgram() {
        this.loadData();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.loadData();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        for (APortView p : this.tabs) {
            p.updateProgram();
        }
    }

    private void loadProps() {
    }

    @Override
    public void saveProps() {
    }

    @Override
    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearModbusRefs();
        this.mainFrame.getModbusEditor().updateSlaveVarRefs();
        for (APortView p : this.tabs) {
            p.updateMasterVarRefs();
        }
        ved.updateTable();
    }

    @Override
    public void updateVarList() {
        for (APortView p : this.tabs) {
            p.updateVarList();
        }
    }
}

