/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.Variable;
import certa.vics.ide.CommSettingsPanel;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ConnectionThread;
import certa.vics.ide.modbus.ModbusArchiveTable;
import certa.vics.ide.modbus.ModbusRegsTable;
import certa.vics.ide.modbus.ModbusScheduleTable;
import certa.vics.ide.modbus.ModbusSlaveEditor;
import certa.vics.ide.modbus.Register;
import certa.vics.ide.schedule.ScheduleEditor;
import certa.vics.ide.schedule.ScheduleTableView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PollDialog
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    static PollDialog dialog;
    protected ModbusSlaveEditor editor;
    protected CommSettingsPanel comm;
    ModbusRegsTable inputs;
    ModbusRegsTable coils;
    ModbusRegsTable iregs;
    ModbusRegsTable hregs;
    ModbusArchiveTable archive;
    ArrayList<ModbusScheduleTable> schedules = new ArrayList();
    JTabbedPane tabbedPane;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    protected ConnectionThread connection;
    ModbusScheduleTable scheduleTable;
    List<Variable> alarmVars;

    public static void showDialog(ModbusSlaveEditor editor, CommSettingsPanel comm, Component owner) {
        if (dialog != null) {
            return;
        }
        dialog = new PollDialog();
        try {
            PollDialog.dialog.editor = editor;
            PollDialog.dialog.comm = comm;
            dialog.loadRegs();
            PollDialog.dialog.connection = new ConnectionThread(dialog);
            dialog.setDisconnectedStatus(null);
            Point p = MainFrame.instance.getClientLocation();
            Dimension d = MainFrame.instance.getClientSize();
            dialog.setSize(new Dimension(d.width / 2, d.height));
            dialog.setLocation(p.x + d.width / 2, p.y);
            dialog.setVisible(true);
        }
        catch (Throwable ex) {
            Utils.ProcessException(ex, false);
            JOptionPane.showMessageDialog(MainFrame.instance, ex.getMessage(), "Error", 0);
        }
    }

    public PollDialog() {
        super("");
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.inputs = new ModbusRegsTable(this, "INPUTS", true, false);
        this.coils = new ModbusRegsTable(this, "COILS", true, true);
        this.iregs = new ModbusRegsTable(this, "INPUT REGS", false, false);
        this.hregs = new ModbusRegsTable(this, "HOLDING REGS", false, true);
        this.archive = new ModbusArchiveTable(this);
        this.tabbedPane = new JTabbedPane();
        this.addTab(this.inputs, "Inputs", "Read only 1-bit discretes");
        this.addTab(this.coils, "Coils", "Writable 1-bit discretes");
        this.addTab(this.iregs, "Input registers", "Read only 16-bit registers");
        this.addTab(this.hregs, "Holding registers", "Writable 16-bit registers");
        this.addTab(this.archive, "\u0410\u0440\u0445\u0438\u0432 \u0430\u0432\u0430\u0440\u0438\u0439", "\u0410\u0440\u0445\u0438\u0432 \u0430\u0432\u0430\u0440\u0438\u0439");
        ScheduleEditor sed = MainFrame.instance.getScheduleEditor();
        for (ScheduleTableView stv : sed.tabs) {
            if (!stv.isPresent()) continue;
            ModbusScheduleTable t = new ModbusScheduleTable(this, sed, stv);
            this.schedules.add(t);
            this.addTab(t, "\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 " + stv.number, stv.getTitle());
        }
        try {
            this.alarmVars = MainFrame.instance.program.RamVars.reallocAlarms();
        }
        catch (CompilerError e1) {
            this.alarmVars = new ArrayList<Variable>();
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int tab = PollDialog.this.tabbedPane.getSelectedIndex();
                if (PollDialog.this.connection != null) {
                    if (tab >= 0 && tab < 4) {
                        PollDialog.this.connection.setRegType(tab + 1);
                        PollDialog.this.connection.setArchiveActive(false);
                        PollDialog.this.connection.setScheduleNumber(0);
                        PollDialog.this.scheduleTable = null;
                    } else if (tab == 4) {
                        PollDialog.this.connection.setRegType(0);
                        PollDialog.this.connection.setArchiveActive(true);
                        Arrays.fill(PollDialog.this.archive.timestamps, null);
                        Arrays.fill(PollDialog.this.archive.alarms, null);
                        PollDialog.this.connection.setScheduleNumber(0);
                        PollDialog.this.scheduleTable = null;
                    } else if (tab > 4) {
                        PollDialog.this.connection.setRegType(0);
                        PollDialog.this.connection.setArchiveActive(false);
                        PollDialog.this.scheduleTable = PollDialog.this.schedules.get(tab - 5);
                        PollDialog.this.connection.setScheduleNumber(PollDialog.this.scheduleTable.tableView.number);
                        PollDialog.this.scheduleTable.lblType.setText("");
                    }
                }
            }
        });
        this.add((Component)this.tabbedPane, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(new JLabel("      \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.pack();
        this.setLocationByPlatform(false);
        this.setResizable(true);
    }

    public void loadRegs() {
        int i = this.editor.getCurrentProfileIndex();
        this.inputs.setRegList(this.editor.inputs[i].list);
        this.coils.setRegList(this.editor.coils[i].list);
        this.iregs.setRegList(this.editor.iregs[i].list);
        this.hregs.setRegList(this.editor.hregs[i].list);
        this.setTitle("MODBUS \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u2116 " + (i + 1));
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        dialog = null;
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void initFocus() {
    }

    private void addTab(JPanel panel, String title, String hint) {
        this.tabbedPane.addTab(title, null, panel, hint);
    }

    public void connected() {
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        this.repaint();
    }

    void setDisconnectedStatus(String error) {
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.repaint();
    }

    public void disconnected(String error) {
        this.connection = null;
        this.setDisconnectedStatus(error);
    }

    private void updateRegsValues(ModbusRegsTable table, Register[] regs) {
        for (int i = 0; i < regs.length; ++i) {
            table.values[i] = regs[i].getValue();
            table.bad[i] = !regs[i].isGood();
            table.writing[i] = regs[i].isWriting();
            table.model.fireTableCellUpdated(i, 2);
        }
    }

    private void updateSchedule() {
        if (this.scheduleTable == null) {
            return;
        }
        if (this.connection.isScheduleEmpty()) {
            this.scheduleTable.lblType.setText("");
            for (int day = 0; day < this.scheduleTable.cells.length; ++day) {
                this.scheduleTable.cells[day][0].i1 = 0;
            }
            return;
        }
        int t = this.connection.schedule[0].getValue();
        if (t == 0) {
            this.scheduleTable.lblType.setText("\u043f\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044e");
        } else if (t == 1) {
            this.scheduleTable.lblType.setText("\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e");
        } else {
            this.scheduleTable.lblType.setText("\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e: " + t);
        }
        for (int day = 0; day < this.scheduleTable.cells.length; ++day) {
            this.scheduleTable.cells[day][0].i1 = this.connection.schedule[1 + 37 * day].getValue();
            this.scheduleTable.model.fireTableCellUpdated(0, day);
            for (int i = 0; i < 12; ++i) {
                this.scheduleTable.cells[day][i + 1].i1 = this.connection.schedule[2 + 3 * i + 37 * day].getValue();
                this.scheduleTable.cells[day][i + 1].i2 = this.connection.schedule[3 + 3 * i + 37 * day].getValue();
                this.scheduleTable.cells[day][i + 1].i3 = this.connection.schedule[4 + 3 * i + 37 * day].getValue();
                this.scheduleTable.model.fireTableCellUpdated(i + 1, day);
            }
        }
    }

    private String decodeTimeStamp(long ts) {
        if (ts != 0xFFFFFFFFL) {
            return String.format("%04d-%02d-%02d %02d:%02d:%02d", 2000L + ts / 32140800L % 100L, ts / 2678400L % 12L + 1L, ts / 86400L % 31L + 1L, ts / 3600L % 24L, ts / 60L % 60L, ts % 60L);
        }
        return null;
    }

    private String decodeAlarm(int alarm) {
        if (alarm != 255) {
            if (alarm >= 0 && alarm < this.alarmVars.size()) {
                return this.alarmVars.get((int)alarm).name;
            }
            return Integer.toString(alarm);
        }
        return null;
    }

    private void updateArchive() {
        if (this.connection.isArchiveLoaded()) {
            for (int i = 0; i < 256; ++i) {
                this.archive.alarms[i] = this.decodeAlarm(this.connection.archive[i * 3 + 0].getValue());
                this.archive.timestamps[i] = this.decodeTimeStamp((long)this.connection.archive[i * 3 + 2].getValue() << 16 | (long)this.connection.archive[i * 3 + 1].getValue());
            }
            this.archive.model.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                this.lblStatusRequests.setText(Integer.toString(this.connection.requestsCount));
                this.lblStatusErrors.setText(Integer.toString(this.connection.errorsCount));
                this.updateRegsValues(this.inputs, this.connection.inputs);
                this.updateRegsValues(this.coils, this.connection.coils);
                this.updateRegsValues(this.iregs, this.connection.iregs);
                this.updateRegsValues(this.hregs, this.connection.hregs);
                this.updateArchive();
                this.updateSchedule();
            }
        }
    }
}

