/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.modbus.PollDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

class ModbusArchiveTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final int ARCHIVE_SIZE = 256;
    static final int COL_INDEX = 0;
    static final int COL_TIMESTAMP = 1;
    static final int COL_ALARM = 2;
    static final String[] COLUMNS = new String[]{"\u041d\u043e\u043c\u0435\u0440", "\u0414\u0430\u0442\u0430/\u0432\u0440\u0435\u043c\u044f", "\u0410\u0432\u0430\u0440\u0438\u044f"};
    static final int[] DEF_COLUMNS_W = new int[]{50, 140, 250};
    final String[] timestamps = new String[256];
    final String[] alarms = new String[256];
    final JTable table;
    final ArchiveTableModel model;
    final PollDialog dialog;
    JPanel pnlParams;
    JButton btnRefresh;

    public ModbusArchiveTable(final PollDialog dialog) {
        this.dialog = dialog;
        this.model = new ArchiveTableModel();
        this.table = new JTable(this.model);
        this.pnlParams = new JPanel(new MigLayout("", "", ""));
        this.btnRefresh = new JButton("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.connection.reloadArchive();
            }
        });
        this.pnlParams.add((Component)this.btnRefresh, "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlParams, "North");
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
        this.setupTable();
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setCellRenderer(new IdeTableCellRenderer(4, 8));
        cm.getColumn(1).setCellRenderer(new IdeTableCellRenderer(2, 8));
        cm.getColumn(2).setCellRenderer(new IdeTableCellRenderer(2, 8));
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(DEF_COLUMNS_W[i]);
        }
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
    }

    public class ArchiveTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getRowCount() {
            return 256;
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < ModbusArchiveTable.this.timestamps.length) {
                if (columnIndex == 0) {
                    return rowIndex + 1;
                }
                if (columnIndex == 1) {
                    return ModbusArchiveTable.this.timestamps[rowIndex];
                }
                if (columnIndex == 2) {
                    return ModbusArchiveTable.this.alarms[rowIndex];
                }
                return null;
            }
            return null;
        }
    }
}

