/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdComment;
import certa.vics.ide.fbd.FbdPage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdCommentText
extends AFbdComment {
    static final String JSON_TEXT = "text";
    static final Font FONT = new Font("Sans", 0, 14);
    static final Color COLOR = new Color(0, 0, 0);
    String[] lines;
    String text;

    public FbdCommentText(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page, src);
        if (src != null) {
            this.text = src.getString(JSON_TEXT);
        }
        if (Utils.strEmpty(this.text)) {
            this.text = "Text";
        }
        this.lines = this.text.trim().split("\n");
        this.updateSize();
    }

    public void setText(String text) {
        if (this.text == text || text == null || this.text.equals(text)) {
            return;
        }
        this.text = text.trim();
        this.lines = this.text.split("\n");
        this.updateSize();
        this.page.markModified();
    }

    private void updateSize() {
        FontMetrics fm = this.page.editor.pane.getFontMetrics(FONT);
        int w = 10;
        for (String s : this.lines) {
            w = Math.max(w, fm.stringWidth(s));
        }
        int h = fm.getHeight();
        this.pxBounds.width = w;
        this.pxBounds.height = h * this.lines.length;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
        jso.put(JSON_TEXT, this.text);
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        FontMetrics fm = g2d.getFontMetrics(FONT);
        int h = fm.getHeight();
        g2d.setColor(COLOR);
        g2d.setFont(FONT);
        int y = this.pxBounds.y + fm.getAscent();
        for (String s : this.lines) {
            g2d.drawString(s, this.pxBounds.x, y);
            y += h;
        }
        this.paintFocus(g2d);
    }

    @Override
    public boolean isEmpty() {
        return Utils.strEmpty(this.text.trim());
    }
}

