/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdComment;
import certa.vics.ide.fbd.FbdPage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdCommentRect
extends AFbdComment {
    static final Color COLOR = new Color(0, 0, 0);
    static final Stroke STROKE = new BasicStroke(1.0f);
    private static final int D = 4;

    public FbdCommentRect(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page, src);
        if (src == null) {
            this.pxBounds.width = 150;
            this.pxBounds.height = 100;
        }
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        g2d.setColor(COLOR);
        g2d.setStroke(STROKE);
        g2d.drawRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        this.paintFocus(g2d);
        if (this.page.editor.focusedComment == this) {
            g2d.fillRect(this.pxBounds.x + this.pxBounds.width - 5, this.pxBounds.y + this.pxBounds.height - 5, 10, 10);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.pxBounds.width <= 0 || this.pxBounds.height <= 0;
    }

    @Override
    public boolean containsPx(int x, int y) {
        int x1 = this.pxBounds.x;
        int x2 = this.pxBounds.x + this.pxBounds.width;
        int y1 = this.pxBounds.y;
        int y2 = this.pxBounds.y + this.pxBounds.height;
        return (x >= x1 - 4 && x <= x1 + 4 || x >= x2 - 4 && x <= x2 + 4 || y >= y1 - 4 && y <= y1 + 4 || y >= y2 - 4 && y <= y2 + 4) && x >= x1 - 4 && x <= x2 + 4 && y >= y1 - 4 && y <= y2 + 4;
    }

    public boolean isResizeArea(int x, int y) {
        int x1 = this.pxBounds.x + this.pxBounds.width;
        int y1 = this.pxBounds.y + this.pxBounds.height;
        int D = 8;
        return x >= x1 - D && x <= x1 + D && y >= y1 - D && y <= y1 + D;
    }
}

