/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractOperation
extends AFbdBlock {
    public final String operation;
    public final String name;
    static final Font NAME_FONT;
    private int nameWidth = -1;
    private int nameHeight = -1;
    private int nameY = -1;

    public AbstractOperation(FbdPage page, JSONObject src, String operation, String name) throws JSONException, FbdLoadError {
        super(page, src);
        this.operation = operation;
        this.name = name;
    }

    @Override
    protected int initWidth(JSONObject src) throws JSONException, FbdLoadError {
        return 2;
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        super.paintShape(g2d);
        g2d.setFont(NAME_FONT);
        if (this.nameWidth < 0) {
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.name, g2d);
            this.nameWidth = (int)rect.getWidth();
            this.nameHeight = (int)rect.getHeight();
            this.nameY = (int)(-rect.getY());
        }
        int x = this.pxBounds.x;
        int y = this.pxBounds.y - 1;
        g2d.setColor(Color.BLACK);
        g2d.drawString(this.name, x + (this.pxBounds.width - this.nameWidth) / 2, y + (this.pxBounds.height - this.nameHeight) / 2 + this.nameY);
    }

    @Override
    public void paintLinks(Graphics2D g2d) {
        super.paintLinks(g2d);
    }

    @Override
    public void makeSpecificCode(ArrayList<String> code) {
        String cmd = this.operation;
        for (InputPin in : this.inputs) {
            cmd = cmd + " " + (in.isArray ? in.getCompiledVar().fullArrayName() : in.getCompiledVar().fullName());
        }
        for (OutputPin out : this.outputs) {
            cmd = cmd + " " + out.getCompiledVar().fullName();
        }
        code.add(cmd);
    }

    static {
        Font fnt;
        try {
            fnt = Font.createFont(0, Utils.getResourceStream("fbd.ttf")).deriveFont(0, 22.0f);
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            fnt = new Font("Sans", 1, 22);
        }
        NAME_FONT = fnt;
    }
}

