/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AbstractOperation;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AGlobalVarsOperation
extends AbstractOperation {
    protected final Variable[] globals;

    public AGlobalVarsOperation(FbdPage page, JSONObject src, String operation, String name, int globalsCount) throws JSONException, FbdLoadError {
        super(page, src, operation, name);
        this.globals = new Variable[globalsCount];
    }

    protected abstract void allocGlobals() throws SyntaxError;

    @Override
    public void compileOutputVars() throws SyntaxError {
        super.compileOutputVars();
        this.allocGlobals();
    }

    @Override
    public void makeSpecificCode(ArrayList<String> code) {
        String cmd = this.operation;
        for (InputPin in : this.inputs) {
            cmd = cmd + " " + (in.isArray ? in.getCompiledVar().fullArrayName() : in.getCompiledVar().fullName());
        }
        for (OutputPin out : this.outputs) {
            cmd = cmd + " " + out.getCompiledVar().fullName();
        }
        for (Variable v : this.globals) {
            cmd = cmd + " " + v.fullName();
        }
        code.add(cmd);
    }
}

