/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.Version;
import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.Argument;
import certa.vics.compiler.ArgumentDef;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.Device;
import certa.vics.compiler.DevpropsError;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuItemVariable;
import certa.vics.compiler.MenuString;
import certa.vics.compiler.MenuStringsBuffer;
import certa.vics.compiler.MenuVariables;
import certa.vics.compiler.ModbusMasterProfile;
import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.Port;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.ScheduleBlock;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Program {
    public static final int PROG_NAME_SIZE = 16;
    public static final int MB_SLAVE_PROFILES = 3;
    static final Port[] EMPTY_PORTS = new Port[0];
    public static final int CURRENT_FILE_VERSION = 600;
    public static final String ZIP_ENTRY_NAME = "program";
    public final VariablesBlock Constants = new VariablesBlock("Const", "ROM", true);
    public final VariablesBlock RamVars = new VariablesBlock("Ram", "RAM", false);
    public final VariablesBlock NvramVars = new VariablesBlock("Ext", "NVRAM", false);
    public final VariablesBlock EepromVars = new VariablesBlock("Store", "EEPROM", false);
    VariablesBlock[] AllVars;
    VariablesBlock[] SysVars;
    VariablesBlock[] UserVars;
    public final CodeBlock MainCode = new CodeBlock("Main");
    public final LinkedHashMap<String, CodeBlock> Subs = new LinkedHashMap();
    public final MenuItemMenu mainMenu = new MenuItemMenu(null, null, 0, "");
    public final MenuStringsBuffer menuStrings = new MenuStringsBuffer();
    public final MenuVariables menuVars = new MenuVariables();
    public ModbusSlaveProfile[] slaveProfiles = new ModbusSlaveProfile[3];
    public Port[] rs485Ports = EMPTY_PORTS;
    public Port[] tcpSlavePorts = EMPTY_PORTS;
    public Port usbPort = null;
    public final ScheduleBlock Schedules = new ScheduleBlock();
    public final ArrayList<String> codeSource = new ArrayList();
    public final ArrayList<String> lastComments = new ArrayList();
    public String extraData;
    private String id = "";
    public int codeCrc = 0;
    public String comment = "";
    public int fileVersion;
    public Device device;
    protected String SourceFile;
    ParseState State;
    public byte[] flash;
    public byte[] eeprom;
    public byte[] nvram;
    public static final String DUMB_VAR_NAME = "___DUMB";
    static final char[] NAME_CHARS = new char[]{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '_', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '_', '_', '_', '_', '\u0411', '\u0413', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041b', '\u041f', '\u0423', '\u0424', '\u0427', '\u0428', '\u042a', '\u042b', '\u042d', '\u042e', '\u042f', '\u0431', '\u0432', '\u0433', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043f', '\u0442', '\u0447', '\u0448', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\"', '\"', '\"', '\"', '\u2116', '_', 'f', 'L', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '\u0414', '\u0426', '\u0429', '\u0434', '\u0444', '\u0446', '\u0449', '\'', '_', '~', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'};
    boolean saveRaw;
    int lineNum;
    public static final String UTF8_BOM = "\ufeff";
    private String[] tokens;
    private int tokenIndex;
    private StringBuilder sbExtraData = new StringBuilder();
    private VariablesBlock varBlock;
    private Variable varCurrent;
    private boolean varInitOnly;
    private int arrayValueIndex;
    private boolean varIsAlarm;
    private boolean varIsArchived;
    private int mbRegType;
    private int mbRegAddr;
    private String tmpVar;
    private String tmpVar2;
    private CodeBlock codeBlock;
    private CommandDef retCommand;
    private Command codeItem;
    private int codeArgIndex;
    private int codeArgListSize;
    private int codeArgListIndex;
    private Schedule schedule;
    private String scheduleParam;
    private ModbusSlaveProfile modbusSlave;
    private Port port;
    private MenuItemMenu _currentMenu;
    private AMenuItem _currentMenuItem;
    private int mbMasterReqType;
    private int mbMasterReqId;
    private int mbMasterReqAddr;
    private int codeFlashSize;
    private int ramInitFlashSize;
    private int ramInitFlashAddress;
    private int constantsFlashSize;
    private int constantsFlashAddress;
    private int hmiVarsFlashSize;
    private int hmiVarsFlashAddress;
    private int menuFlashSize;
    private int menuFlashAddress;
    private int[] slaveProfileFlashAddress = new int[3];
    private int[] masterProfileFlashAddress = new int[0];
    private int flashCRC;
    public final int COMMANDS_FLASH_OFFSET = 155;

    public Program() {
        this.clear(false);
    }

    public Program(Device dev) {
        this.clear(false);
        this.assignDevice(dev);
        this.fileVersion = 600;
    }

    public static String regsToProgName(int r1, int r2, int r3, int r4, int r5, int r6, int r7, int r8) {
        int i;
        String s = "" + NAME_CHARS[r1 & 0xFF] + NAME_CHARS[r1 >>> 8 & 0xFF] + NAME_CHARS[r2 & 0xFF] + NAME_CHARS[r2 >>> 8 & 0xFF] + NAME_CHARS[r3 & 0xFF] + NAME_CHARS[r3 >>> 8 & 0xFF] + NAME_CHARS[r4 & 0xFF] + NAME_CHARS[r4 >>> 8 & 0xFF] + NAME_CHARS[r5 & 0xFF] + NAME_CHARS[r5 >>> 8 & 0xFF] + NAME_CHARS[r6 & 0xFF] + NAME_CHARS[r6 >>> 8 & 0xFF] + NAME_CHARS[r7 & 0xFF] + NAME_CHARS[r7 >>> 8 & 0xFF] + NAME_CHARS[r8 & 0xFF] + NAME_CHARS[r8 >>> 8 & 0xFF];
        for (i = s.length() - 1; i > 0 && s.charAt(i) <= ' '; --i) {
        }
        return s.substring(0, i + 1);
    }

    public String getProgId() {
        return this.id;
    }

    public void setProgId(String id) {
        int i;
        for (i = id.length() - 1; i >= 0 && Character.isWhitespace(id.charAt(i)); --i) {
        }
        id = id.substring(0, i + 1);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < Math.min(id.length(), 16); ++i) {
            char c = id.charAt(i);
            if (c <= ' ' || c > '~') {
                c = '_';
            }
            sb.append(c);
        }
        this.id = sb.toString();
    }

    public String getEncodedId() {
        String s = Utils.strEmpty(this.id) ? "_" : this.id;
        s.replace(' ', '_');
        return s;
    }

    public boolean hasSchedule() {
        return this.device.HasSchedule;
    }

    public boolean hasArchive() {
        return this.device.HasArchive;
    }

    public void clear(boolean preserveDevice) {
        if (!preserveDevice) {
            this.device = null;
            this.AllVars = null;
            this.SysVars = null;
            this.UserVars = null;
            for (int i = 0; i < 3; ++i) {
                this.slaveProfiles[i] = new ModbusSlaveProfile(i);
            }
            this.rs485Ports = EMPTY_PORTS;
            this.tcpSlavePorts = EMPTY_PORTS;
            this.usbPort = null;
        }
        this.clearVars();
        this.mainMenu.clear();
        this.menuStrings.clear();
        this.menuVars.clear();
        this.Schedules.clear();
        this.clearCode();
        this.extraData = "";
    }

    public void clearVars() {
        this.RamVars.clear();
        this.NvramVars.clear();
        this.Constants.clear();
        this.EepromVars.clear();
        try {
            Variable dumb = this.RamVars.createSimpleVar(DUMB_VAR_NAME, 2, false, false, true);
            for (int i = 0; i < 3; ++i) {
                this.slaveProfiles[i].clear(dumb);
            }
        }
        catch (SyntaxError e) {
            throw new Error(e);
        }
    }

    protected void clearCode() {
        this.codeSource.clear();
        this.lastComments.clear();
        this.saveRaw = false;
        this.MainCode.clear();
        this.Subs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String fileName, boolean resolve) throws IOException, ErrorInFile, DevpropsError {
        Path path = Paths.get(fileName, new String[0]).toRealPath(new LinkOption[0]);
        Charset charset = Charset.forName("UTF-8");
        BufferedReader reader = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(path.toFile());
        }
        catch (ZipException e) {
            reader = Files.newBufferedReader(path, charset);
        }
        if (zip != null) {
            ZipEntry ze = zip.getEntry(ZIP_ENTRY_NAME);
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(ze), charset));
        }
        try {
            this.load(reader, resolve, path.toString());
        }
        finally {
            reader.close();
            if (zip != null) {
                zip.close();
            }
        }
    }

    public void load(BufferedReader reader, boolean resolve, String file) throws IOException, ErrorInFile, DevpropsError {
        this.SourceFile = file;
        this.lineNum = 1;
        this.State = ParseState.PARSE_START;
        this.fileVersion = 0;
        try {
            this.clear(false);
            this.sbExtraData.setLength(0);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(UTF8_BOM)) {
                    line = line.substring(1);
                }
                this.parseLine(line, false);
                ++this.lineNum;
            }
            if (this.State != ParseState.PARSE_END) {
                throw new SyntaxError("Unexpected end of file (End is required)");
            }
            this.extraData = this.sbExtraData.toString().trim();
            this.lineNum = 0;
            if (resolve) {
                if (!Utils.strEmpty(this.extraData)) {
                    throw new SyntaxError("This is not ViCS file");
                }
                this.resolveLinks();
            }
        }
        catch (MalformedInputException e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, "Invalid file charset (must be UTF-8)");
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, e.line > 0 ? e.line : this.lineNum, e);
        }
        catch (DevpropsError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
        }
        this.checkAllCode();
        this.trimSource();
    }

    public void resolveLinks() throws SyntaxError {
        this.mainMenu.resolveLinks(this);
        for (int i = 0; i < 3; ++i) {
            this.slaveProfiles[i].resolveLinks(this);
        }
        for (Port p : this.rs485Ports) {
            if (!p.hasMasterProfile()) continue;
            p.masterProfile.resolveLinks(this);
        }
        if (this.hasSchedule()) {
            this.Schedules.resolveLinks(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCode(String[] lines) throws ErrorInFile {
        String t = this.SourceFile;
        this.SourceFile = "Code";
        try {
            this.lineNum = 1;
            this.State = ParseState.BLOCK_BEGIN;
            try {
                this.clearCode();
                for (String s : lines) {
                    this.parseLine(s, true);
                    ++this.lineNum;
                }
            }
            catch (SyntaxError e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e);
            }
            catch (Exception e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
            }
            this.checkAllCode();
            this.trimSource();
        }
        finally {
            this.SourceFile = t;
        }
    }

    protected void parseLine(String line, boolean onlyCode) throws FileNotFoundException, SyntaxError, IOException, ErrorInFile, DevpropsError {
        if (this.State == ParseState.PARSE_END) {
            this.sbExtraData.append(line);
            this.sbExtraData.append('\n');
            return;
        }
        String rawLine = line;
        if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) {
            this.lastComments.add(rawLine);
        } else {
            this.tokens = line.split("\\s+");
            this.tokenIndex = 0;
            while (this.tokenIndex < this.tokens.length && this.State != ParseState.PARSE_END) {
                this.State = this.parseToken(this.tokens[this.tokenIndex], onlyCode, this.tokenIndex == this.tokens.length - 1);
                ++this.tokenIndex;
            }
            if (this.saveRaw) {
                this.codeSource.addAll(this.lastComments);
                this.codeSource.add(rawLine);
            }
            this.lastComments.clear();
        }
    }

    private void checkAllCode() throws ErrorInFile {
        this.checkCode(this.MainCode);
        for (CodeBlock sub : this.Subs.values()) {
            this.checkCode(sub);
        }
    }

    private void checkCode(CodeBlock cb) throws ErrorInFile {
        int line = 0;
        try {
            for (Command ci : cb.Items) {
                line = ci.srcLine;
                for (Argument arg : ci.Args) {
                    if (arg.Type == 3) {
                        this.resolveLabel((String)arg.Value, cb);
                        continue;
                    }
                    if (arg.Type != 4) continue;
                    this.resolveSub((String)arg.Value);
                }
            }
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, line, e);
        }
    }

    protected void trimSource() {
        while (this.codeSource.size() > 0 && this.codeSource.get(0).trim().length() == 0) {
            this.codeSource.remove(0);
        }
    }

    public String getSourceFile() {
        return this.SourceFile;
    }

    private void processVersion(String s) throws SyntaxError {
        try {
            this.fileVersion = Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("Invalid file version: " + s);
        }
        if (this.fileVersion > 600) {
            throw new OldEditorError();
        }
    }

    private void assignDevice(Device dev) {
        int i;
        this.device = dev;
        this.AllVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars, this.Constants, this.RamVars, this.NvramVars, this.EepromVars};
        this.SysVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars};
        this.UserVars = new VariablesBlock[]{this.Constants, this.RamVars, this.NvramVars, this.EepromVars};
        this.rs485Ports = new Port[this.device.RS485count];
        for (i = 0; i < this.rs485Ports.length; ++i) {
            this.rs485Ports[i] = new Port(Port.PortType.RS485, i, this.slaveProfiles[0]);
        }
        if (this.device.HasEthernet) {
            this.tcpSlavePorts = new Port[this.device.RS485count];
        }
        for (i = 0; i < this.tcpSlavePorts.length; ++i) {
            this.tcpSlavePorts[i] = new Port(Port.PortType.TCP, i, this.slaveProfiles[0]);
        }
        if (this.device.HasUSB) {
            this.usbPort = new Port(Port.PortType.USB, 0, this.slaveProfiles[0]);
        }
    }

    private VariablesBlock locateBlock(VariablesBlock[] blocks, String name) {
        if (blocks != null) {
            for (VariablesBlock b : blocks) {
                if (!b.name.equalsIgnoreCase(name)) continue;
                return b;
            }
        }
        return null;
    }

    public VariablesBlock locateSysBlock(String name) {
        return this.locateBlock(this.SysVars, name);
    }

    public VariablesBlock locateUserBlock(String name) {
        return this.locateBlock(this.UserVars, name);
    }

    private ParseState parseToken(String token, boolean onlyCode, boolean endOfLine) throws SyntaxError, FileNotFoundException, IOException, ErrorInFile, DevpropsError {
        if (this.State == ParseState.PARSE_START) {
            if (token.equalsIgnoreCase("FileVersion")) {
                return ParseState.FILE_VERSION;
            }
            if (token.equalsIgnoreCase("ID")) {
                return ParseState.PROG_ID;
            }
            if (token.equalsIgnoreCase("CodeCRC")) {
                return ParseState.CODE_CRC;
            }
            this.require(token, "Target");
            return ParseState.TARGET;
        }
        if (this.State == ParseState.FILE_VERSION) {
            this.processVersion(token);
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.PROG_ID) {
            this.id = token;
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.CODE_CRC) {
            this.codeCrc = Program.decodeInt(token, "Invalid number");
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.TARGET) {
            this.assignDevice(new Device(token));
            return ParseState.BLOCK_BEGIN;
        }
        if (this.State == ParseState.BLOCK_BEGIN) {
            this.saveRaw = false;
            if (token.equalsIgnoreCase(this.MainCode.Name)) {
                return this.openCodeBlock(this.MainCode, this.device.CommandMap.get("END"));
            }
            if (token.equalsIgnoreCase("Sub")) {
                this.saveRaw = true;
                return ParseState.SUB;
            }
            if (onlyCode) {
                throw new SyntaxError("Unknown block: \"" + token + "\" (expected Main, Sub)");
            }
            if (token.equalsIgnoreCase("Const")) {
                return this.openVarDomain(this.Constants, false);
            }
            if (token.equalsIgnoreCase("Ram")) {
                return this.openVarDomain(this.RamVars, false);
            }
            if (token.equalsIgnoreCase("Ext")) {
                return this.openVarDomain(this.NvramVars, false);
            }
            if (token.equalsIgnoreCase("Store")) {
                return this.openVarDomain(this.EepromVars, false);
            }
            if (token.equalsIgnoreCase("SysOut")) {
                return this.openVarDomain(this.device.SysOutVars, true);
            }
            if (token.equalsIgnoreCase("SysStore")) {
                return this.openVarDomain(this.device.SysStoreVars, true);
            }
            if (token.equalsIgnoreCase("SysExt")) {
                return this.openVarDomain(this.device.SysExtVars, true);
            }
            if (token.equalsIgnoreCase("ModbusSlave")) {
                return ParseState.MODBUS_SLAVE_NAME;
            }
            if (token.equalsIgnoreCase("Port")) {
                return ParseState.PORT_TYPE;
            }
            if (token.equalsIgnoreCase("RootMenu")) {
                return this.beginMenu(true);
            }
            if (token.equalsIgnoreCase("Schedule")) {
                return ParseState.SCHEDULE;
            }
            if (token.equalsIgnoreCase("Archive")) {
                return ParseState.ARCHIVE_VAR;
            }
            if (token.equalsIgnoreCase("End")) {
                return ParseState.PARSE_END;
            }
            throw new SyntaxError("Unknown block: \"" + token + "\"");
        }
        if (this.State == ParseState.VAR_NAME) {
            return this.parseVarName(token);
        }
        if (this.State == ParseState.VAR_VALUE) {
            return this.parseVarValue(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_NAME) {
            return this.parseModbusSlaveName(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_REG) {
            return this.parseMbSlaveReg(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_VAR) {
            return this.parseMbSlaveVar(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_K) {
            if (token.equals("$")) {
                return ParseState.MODBUS_SLAVE_K_VALUE;
            }
            this.modbusSlave.allocUnresolved(this.mbRegType, this.mbRegAddr, this.tmpVar, 0);
            return this.parseMbSlaveReg(token);
        }
        if (this.State == ParseState.MODBUS_SLAVE_K_VALUE) {
            return this.parseMbSlaveKValue(token);
        }
        if (this.State == ParseState.PORT_TYPE) {
            return this.parsePortType(token);
        }
        if (this.State == ParseState.PORT_RS485_INDEX) {
            return this.parsePortIndex(this.rs485Ports, token);
        }
        if (this.State == ParseState.PORT_TCP_INDEX) {
            return this.parsePortIndex(this.tcpSlavePorts, token);
        }
        if (this.State == ParseState.PORT_RS485_TCPGW) {
            return this.parsePortTcpGw(token);
        }
        if (this.State == ParseState.PORT_MODE) {
            return this.parsePortMode(token);
        }
        if (this.State == ParseState.PORT_SLAVE_PROFILE) {
            return this.parsePortSlaveProfile(token);
        }
        if (this.State == ParseState.PORT_RS485_SLAVE_GW) {
            return this.parsePortRS485SlaveGw(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_TIMEOUT) {
            return this.parseMbMasterTimeout(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_PAUSE) {
            return this.parseMbMasterPause(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_VXMODULES) {
            return this.parseMbMasterVxModules(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQUEST) {
            return this.parseMbMasterReqStart(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_TYPE) {
            return this.parseMbMasterReqType(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_ID) {
            return this.parseMbMasterReqId(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_ADDR) {
            return this.parseMbMasterReqAddr(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_CMDVAR) {
            return this.parseMbMasterReqCmdVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_RESULTVAR) {
            return this.parseMbMasterReqResultVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REQ_ERRCOUNTVAR) {
            return this.parseMbMasterReqErrCountVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REGISTER) {
            return this.parseMbMasterRegVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REG_K) {
            if (token.equals("$")) {
                return ParseState.MODBUS_MASTER_REG_K_VALUE;
            }
            this.port.masterProfile.allocUnresolvedVar(this.tmpVar, 0);
            return this.parseMbMasterRegVar(token);
        }
        if (this.State == ParseState.MODBUS_MASTER_REG_K_VALUE) {
            return this.parseMbMasterKValue(token);
        }
        if (this.State == ParseState.CMD) {
            return this.parseCommand(token);
        }
        if (this.State == ParseState.CMD_ARG) {
            return this.parseCommandArg(token);
        }
        if (this.State == ParseState.SUB) {
            return this.parseSub(token);
        }
        if (this.State == ParseState.SCHEDULE) {
            return this.parseSchedule(token);
        }
        if (this.State == ParseState.SCHED_PARAM_NAME) {
            return this.parseScheduleParamName(token);
        }
        if (this.State == ParseState.SCHED_PARAM_VALUE) {
            return this.parseScheduleParamValue(token);
        }
        if (this.State == ParseState.MENUITEM) {
            return this.parseMenuItem(token);
        }
        if (this.State == ParseState.MENUITEM_VIS_ACCESS) {
            return this.parseMenuItemAccess(token);
        }
        if (this.State == ParseState.MENUITEM_NAME) {
            return this.parseMenuItemName(token);
        }
        if (this.State == ParseState.MENUITEM_VAR) {
            return this.parseMenuItemVar(token);
        }
        if (this.State == ParseState.MENUITEM_VAR_DIGITS) {
            return this.parseMenuItemVarDigits(token);
        }
        if (this.State == ParseState.MENUITEM_VAR_RW) {
            return this.parseMenuItemVarRW(token);
        }
        if (this.State == ParseState.MENUITEM_VAR_MIN) {
            return this.parseMenuItemVarMin(token);
        }
        if (this.State == ParseState.MENUITEM_VAR_MAX) {
            return this.parseMenuItemVarMax(token);
        }
        if (this.State == ParseState.MENUITEM_VAR_STRINGS) {
            return this.parseMenuItemVarStrings(token);
        }
        if (this.State == ParseState.PARSE_END) {
            throw new SyntaxError("Symbols after End not allowed: \"" + token + "\"");
        }
        throw new SyntaxError("Parser Error at token " + token + ", state=" + this.State.name());
    }

    private ParseState beginMenu(boolean isRoot) {
        if (isRoot) {
            this._currentMenu = this.mainMenu;
            this._currentMenuItem = null;
            return ParseState.MENUITEM;
        }
        this._currentMenu = new MenuItemMenu(this._currentMenu, null, 0, "");
        this._currentMenuItem = this._currentMenu;
        return ParseState.MENUITEM_VIS_ACCESS;
    }

    private ParseState beginVarMenuItem(boolean isText) {
        this._currentMenuItem = new MenuItemVariable(this._currentMenu, null, 0, "", isText);
        return ParseState.MENUITEM_VIS_ACCESS;
    }

    private ParseState parseMenuItem(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("Menu")) {
            return this.beginMenu(false);
        }
        if (token.equalsIgnoreCase("VarNum")) {
            return this.beginVarMenuItem(false);
        }
        if (token.equalsIgnoreCase("VarText")) {
            return this.beginVarMenuItem(true);
        }
        if (token.equalsIgnoreCase("EndMenu")) {
            this._currentMenu = this._currentMenu.parent;
            this._currentMenuItem = null;
            return ParseState.MENUITEM;
        }
        if (token.equalsIgnoreCase("EndRootMenu")) {
            return ParseState.BLOCK_BEGIN;
        }
        throw new SyntaxError("Parser Error");
    }

    private ParseState parseMenuItemAccess(String token) throws SyntaxError {
        if (token.length() == 1) {
            this._currentMenuItem.setAccess(Program.decodeIntRange(token, "Menu item access", 0, 3));
            return ParseState.MENUITEM_NAME;
        }
        this._currentMenuItem.setVisibleVarName(token);
        return ParseState.MENUITEM_VIS_ACCESS;
    }

    private ParseState parseMenuItemName(String token) {
        this._currentMenuItem.setName(MenuString.makeNormal(token));
        if (this._currentMenuItem instanceof MenuItemMenu) {
            return ParseState.MENUITEM;
        }
        return ParseState.MENUITEM_VAR;
    }

    private ParseState parseMenuItemVar(String token) throws SyntaxError {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        vmi.setVarName(token);
        return ParseState.MENUITEM_VAR_RW;
    }

    private ParseState parseMenuItemVarRW(String token) {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        vmi.setWritable(token.equalsIgnoreCase("w"));
        if (vmi.isText) {
            return ParseState.MENUITEM_VAR_STRINGS;
        }
        return ParseState.MENUITEM_VAR_DIGITS;
    }

    private ParseState parseMenuItemVarDigits(String token) throws SyntaxError {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        if (vmi.isText) {
            throw new SyntaxError("Menu item must be numeric variable");
        }
        vmi.setNumDigits(Program.decodeIntRange(token, "Menu item digits", 0, 4));
        if (vmi.isWritable()) {
            return ParseState.MENUITEM_VAR_MIN;
        }
        return ParseState.MENUITEM;
    }

    private ParseState parseMenuItemVarMin(String token) throws SyntaxError {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        if (vmi.isText) {
            throw new SyntaxError("Menu item must be numeric variable");
        }
        vmi.setNumMin(Program.decodeInt(token, "Invalid min value"));
        return ParseState.MENUITEM_VAR_MAX;
    }

    private ParseState parseMenuItemVarMax(String token) throws SyntaxError {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        if (vmi.isText) {
            throw new SyntaxError("Menu item must be numeric variable");
        }
        vmi.setNumMax(Program.decodeInt(token, "Invalid max value"));
        return ParseState.MENUITEM;
    }

    private ParseState parseMenuItemVarStrings(String token) throws SyntaxError {
        MenuItemVariable vmi = (MenuItemVariable)this._currentMenuItem;
        if (!vmi.isText) {
            throw new SyntaxError("Menu item must be text variable");
        }
        vmi.parseStrings(token);
        return ParseState.MENUITEM;
    }

    private ParseState openVarDomain(VariablesBlock d, boolean initOnly) {
        this.varBlock = d;
        this.varCurrent = null;
        this.varInitOnly = initOnly;
        return ParseState.VAR_NAME;
    }

    private ParseState openCodeBlock(CodeBlock b, CommandDef ret) throws SyntaxError {
        this.codeBlock = b;
        if (this.codeBlock.Items.size() > 0) {
            throw new SyntaxError("Duplicate code block: " + b.Name);
        }
        this.retCommand = ret;
        this.saveRaw = true;
        return ParseState.CMD;
    }

    private ParseState parseVarName(String token) throws SyntaxError {
        String varName;
        int varType;
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        if (token.equals("=")) {
            this.arrayValueIndex = 0;
            return ParseState.VAR_VALUE;
        }
        if (token.equals("#")) {
            return this.parseVarComment();
        }
        if (token.equals("A")) {
            this.varIsAlarm = true;
            this.varIsArchived = false;
            return ParseState.VAR_NAME;
        }
        if (token.equals("H")) {
            this.varIsAlarm = true;
            this.varIsArchived = true;
            return ParseState.VAR_NAME;
        }
        try {
            varType = Variable.stringToType(token.substring(0, 1));
            if (varType == 0) {
                throw new SyntaxError("Invalid variable type: \"" + token + "\" (expected b, i, f)");
            }
            varName = token.substring(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SyntaxError("Invalid variable name: \"" + token + "\"");
        }
        if (this.varInitOnly) {
            this.varCurrent = this.varBlock.locateVar(varName, varType);
        } else {
            int p0 = varName.indexOf(123);
            int p1 = varName.indexOf(125);
            if (p0 > 0 && p1 > p0 + 1) {
                String s = varName.substring(p0 + 1, p1);
                int size = Program.decodeInt(s, "Invalid array size");
                this.varCurrent = this.varBlock.createArrayVar(varName.substring(0, p0), varType, size, this.Constants);
            } else {
                this.varCurrent = this.varBlock.createSimpleVar(varName, varType, this.varIsAlarm, this.varIsArchived, false);
            }
        }
        this.varIsAlarm = false;
        this.varIsArchived = false;
        if (this.varCurrent == null) {
            throw new SyntaxError("Unknown variable: \"" + token + "\"");
        }
        return ParseState.VAR_NAME;
    }

    private ParseState parseVarComment() throws SyntaxError {
        String c = "";
        if (++this.tokenIndex < this.tokens.length) {
            c = this.tokens[this.tokenIndex++];
        }
        while (this.tokenIndex < this.tokens.length) {
            c = c + " " + this.tokens[this.tokenIndex++];
        }
        if (Utils.strEmpty(this.varCurrent.comment)) {
            this.varCurrent.comment = c;
        }
        return ParseState.VAR_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParseState parseVarValue(String token) throws SyntaxError {
        double v;
        if (this.varCurrent.type == 1) {
            if (token.equals("1")) {
                v = 1.0;
            } else {
                if (!token.equals("0")) throw new SyntaxError("Invalid bool value: \"" + token + "\" (expected 0, 1)");
                v = 0.0;
            }
        } else if (this.varCurrent.type == 2) {
            v = Program.decodeInt(token, "Invalid int value");
        } else {
            if (this.varCurrent.type != 3) throw new SyntaxError("Internal error");
            v = Program.decodeFloat(token, "Invalid float value");
        }
        if (this.varCurrent.arrayItems != null) {
            this.varCurrent.arrayItems[this.arrayValueIndex].initValue = v;
            if (++this.arrayValueIndex < this.varCurrent.arrayItems.length) return ParseState.VAR_VALUE;
            return ParseState.VAR_NAME;
        }
        this.varCurrent.initValue = v;
        return ParseState.VAR_NAME;
    }

    private ParseState parseModbusSlaveName(String token) throws SyntaxError {
        int index = Program.decodeInt(token, "Invalid int value");
        if (index < 1 || index > 3) {
            throw new SyntaxError("Invalid MODBUS Slave profile index: " + index);
        }
        this.modbusSlave = this.slaveProfiles[index - 1];
        return ParseState.MODBUS_SLAVE_REG;
    }

    private ParseState parsePortType(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("RS485")) {
            return ParseState.PORT_RS485_INDEX;
        }
        if (token.equalsIgnoreCase("TCP")) {
            return ParseState.PORT_TCP_INDEX;
        }
        if (token.equalsIgnoreCase("USB")) {
            this.port = this.usbPort;
            return ParseState.PORT_MODE;
        }
        throw new SyntaxError("Invalid port type: " + token);
    }

    private ParseState parsePortIndex(Port[] ports, String token) throws SyntaxError {
        int index = Program.decodeInt(token, "Invalid int value");
        if (index < 1 || index > this.device.RS485count) {
            throw new SyntaxError("Invalid port index: " + index);
        }
        this.port = ports[index - 1];
        if (this.port.type == Port.PortType.RS485) {
            return ParseState.PORT_RS485_TCPGW;
        }
        return ParseState.PORT_MODE;
    }

    private ParseState parsePortTcpGw(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("TCPGW")) {
            this.port.isRs485TcpGateway = true;
            return ParseState.PORT_MODE;
        }
        if (token.equalsIgnoreCase("NoTCPGW")) {
            return ParseState.PORT_MODE;
        }
        return this.parsePortMode(token);
    }

    private ParseState parsePortMode(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("MASTER")) {
            this.port.isRs485Master = true;
            this.port.masterProfile = new ModbusMasterProfile();
            return ParseState.MODBUS_MASTER_TIMEOUT;
        }
        if (token.equalsIgnoreCase("SLAVE")) {
            return ParseState.PORT_SLAVE_PROFILE;
        }
        throw new SyntaxError("Invalid port mode: " + token);
    }

    private ParseState parsePortSlaveProfile(String token) throws SyntaxError {
        int index = Program.decodeInt(token, "Invalid int value");
        if (index < 0 || index > this.slaveProfiles.length) {
            throw new SyntaxError("Invalid port SLAVE profile: " + index);
        }
        this.port.slaveProfile = index > 0 ? this.slaveProfiles[index - 1] : this.slaveProfiles[0];
        return ParseState.PORT_RS485_SLAVE_GW;
    }

    private ParseState parsePortRS485SlaveGw(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("ENDPORT")) {
            return ParseState.BLOCK_BEGIN;
        }
        if (this.port.type == Port.PortType.RS485) {
            int index = Program.decodeInt(token, "Invalid int value");
            if (index < 0 || index > this.device.RS485count) {
                throw new SyntaxError("Invalid RS485 gateway target port index: " + index);
            }
            this.port.gatewayTargetRS485index = index - 1;
            return ParseState.PORT_RS485_SLAVE_GW;
        }
        throw new SyntaxError("EndPort is expected instead of " + token);
    }

    private ParseState parseMbMasterTimeout(String token) throws SyntaxError {
        this.port.masterProfile.timeout = Program.decodeInt(token, "Invalid int value");
        return ParseState.MODBUS_MASTER_PAUSE;
    }

    private ParseState parseMbMasterPause(String token) throws SyntaxError {
        this.port.masterProfile.pause = Program.decodeInt(token, "Invalid int value");
        return ParseState.MODBUS_MASTER_VXMODULES;
    }

    private ParseState parseMbMasterVxModules(String token) throws SyntaxError {
        int n = Utils.StringToIntDef(token, -1);
        if (n == -1) {
            this.port.masterProfile.vxModules = 0;
            return this.parseMbMasterReqStart(token);
        }
        this.port.masterProfile.vxModules = n;
        return ParseState.MODBUS_MASTER_REQUEST;
    }

    private ParseState parseMbMasterReqStart(String token) throws SyntaxError {
        if (token.equalsIgnoreCase("REQUEST")) {
            return ParseState.MODBUS_MASTER_REQ_TYPE;
        }
        if (token.equalsIgnoreCase("ENDPORT")) {
            return ParseState.BLOCK_BEGIN;
        }
        throw new SyntaxError("Invalid MODBUS Master request: " + token);
    }

    private ParseState parseMbMasterReqType(String token) throws SyntaxError {
        this.mbMasterReqType = Program.decodeIntRange(token, "Invalid MODBUS function", 1, 16);
        if (this.mbMasterReqType > 6 && this.mbMasterReqType < 15) {
            throw new SyntaxError("Invalid MODBUS function: " + this.mbMasterReqType);
        }
        return ParseState.MODBUS_MASTER_REQ_ID;
    }

    private ParseState parseMbMasterReqId(String token) throws SyntaxError {
        this.mbMasterReqId = Program.decodeIntRange(token, "Invalid MODBUS ID", 0, 255);
        return ParseState.MODBUS_MASTER_REQ_ADDR;
    }

    private ParseState parseMbMasterReqAddr(String token) throws SyntaxError {
        this.mbMasterReqAddr = Program.decodeIntRange(token, "Invalid MODBUS register address", 0, 65535);
        return ParseState.MODBUS_MASTER_REQ_CMDVAR;
    }

    private ParseState parseMbMasterReqCmdVar(String token) {
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_MASTER_REQ_RESULTVAR;
    }

    private ParseState parseMbMasterReqResultVar(String token) {
        this.tmpVar2 = token.equals("0") ? null : token;
        return ParseState.MODBUS_MASTER_REQ_ERRCOUNTVAR;
    }

    private ParseState parseMbMasterReqErrCountVar(String token) {
        String sv = token.equals("0") ? null : token;
        this.port.masterProfile.allocUnresolvedRequest(this.mbMasterReqType, this.mbMasterReqId, this.mbMasterReqAddr, this.tmpVar, this.tmpVar2, sv);
        return ParseState.MODBUS_MASTER_REGISTER;
    }

    private ParseState parseMbMasterRegVar(String token) {
        if (token.equalsIgnoreCase("REQUEST")) {
            return ParseState.MODBUS_MASTER_REQ_TYPE;
        }
        if (token.equalsIgnoreCase("ENDPORT")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_MASTER_REG_K;
    }

    private ParseState parseMbMasterKValue(String token) throws SyntaxError {
        int digits = Program.decodeIntRange(token, "Invalid MODBUS register K", 0, 3);
        this.port.masterProfile.allocUnresolvedVar(this.tmpVar, digits);
        return ParseState.MODBUS_MASTER_REGISTER;
    }

    private ParseState parseMbSlaveReg(String token) throws SyntaxError {
        block7: {
            try {
                String t = token.toUpperCase();
                if (t.startsWith("INPUT")) {
                    this.mbRegType = 1;
                    this.mbRegAddr = Integer.decode(token.substring(5));
                    break block7;
                }
                if (t.startsWith("COIL")) {
                    this.mbRegType = 2;
                    this.mbRegAddr = Integer.decode(token.substring(4));
                    break block7;
                }
                if (t.startsWith("IR")) {
                    this.mbRegType = 3;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("HR")) {
                    this.mbRegType = 4;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("END")) {
                    return ParseState.BLOCK_BEGIN;
                }
                throw new SyntaxError("Invalid MODBUS register: " + token);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid MODBUS register address: " + token);
            }
        }
        return ParseState.MODBUS_SLAVE_VAR;
    }

    private ParseState parseMbSlaveVar(String token) throws SyntaxError {
        this.tmpVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_SLAVE_K;
    }

    private ParseState parseMbSlaveKValue(String token) throws SyntaxError {
        int digits = Program.decodeIntRange(token, "Invalid MODBUS register K", 0, 3);
        this.modbusSlave.allocUnresolved(this.mbRegType, this.mbRegAddr, this.tmpVar, digits);
        return ParseState.MODBUS_SLAVE_REG;
    }

    private void require(String srcToken, String reqToken) throws SyntaxError {
        if (!srcToken.equalsIgnoreCase(reqToken)) {
            throw new SyntaxError("\"" + reqToken + "\" is missing");
        }
    }

    public Variable locateVar(String fullName) throws SyntaxError {
        if ("SysStore.i.RS485_1_Slave_ID".equals(fullName)) {
            fullName = "SysStore.i.RS485_1_ID";
        }
        if ("SysStore.i.RS485_2_Slave_ID".equals(fullName)) {
            fullName = "SysStore.i.RS485_2_ID";
        }
        if ("SysStore.i.RS485_3_Slave_ID".equals(fullName)) {
            fullName = "SysStore.i.RS485_3_ID";
        }
        if ("SysStore.i.RS485_4_Slave_ID".equals(fullName)) {
            fullName = "SysStore.i.RS485_4_ID";
        }
        Variable.NameParser vn = new Variable.NameParser(fullName);
        for (VariablesBlock d : this.AllVars) {
            Variable var;
            if (!d.name.equalsIgnoreCase(vn.domain) || (var = d.locateVar(vn.name, vn.type)) == null) continue;
            return var;
        }
        throw new SyntaxError("Unknown variable: \"" + fullName + "\"");
    }

    private int getCodeLineNum() {
        return this.codeSource.size() + this.lastComments.size() + 1;
    }

    private ParseState parseCommand(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            this.codeBlock.addItem(this.retCommand, this.getCodeLineNum());
            return ParseState.BLOCK_BEGIN;
        }
        if (token.startsWith(":")) {
            this.codeBlock.addLabel(token.substring(1));
            return ParseState.CMD;
        }
        CommandDef cmd = this.device.CommandMap.get(token.toUpperCase());
        if (cmd == null) {
            throw new SyntaxError("Unknown command: \"" + token + "\"");
        }
        this.codeItem = this.codeBlock.addItem(cmd, this.getCodeLineNum());
        this.codeArgIndex = 0;
        this.codeArgListSize = 0;
        this.codeArgListIndex = -1;
        if (cmd.Args.length == 0) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    private ParseState parseCommandArg(String token) throws SyntaxError {
        ArgumentDef arg = this.codeItem.cmdDef.Args[this.codeArgIndex];
        if (arg.IsList) {
            if (this.codeArgListIndex < 0) {
                if (!arg.NoListSize) {
                    this.codeArgListSize = Program.decodeInt(token, "Invalid number");
                    if (this.codeArgListSize <= 0 || this.codeArgListSize > 255) {
                        throw new SyntaxError("Invalid list size:" + this.codeArgListSize);
                    }
                    this.codeItem.addNumArg(arg, this.codeArgListSize, false);
                    this.codeArgListIndex = 0;
                    return ParseState.CMD_ARG;
                }
                this.codeArgListIndex = 0;
            }
            this.addSingleArg(token, arg);
            ++this.codeArgListIndex;
            if (this.codeArgListIndex >= this.codeArgListSize) {
                ++this.codeArgIndex;
                this.codeArgListIndex = -1;
            }
        } else {
            this.addSingleArg(token, arg);
            ++this.codeArgIndex;
        }
        if (this.codeArgIndex >= this.codeItem.cmdDef.Args.length) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSingleArg(String fullName, ArgumentDef def) throws SyntaxError {
        if (def.Type == 100) {
            this.codeItem.addLabelArg(def, fullName);
            return;
        } else if (def.Type == 101) {
            this.codeItem.addSubCallArg(def, fullName);
            return;
        } else if (def.Type == 102) {
            this.codeItem.addNumArg(def, Program.decodeInt(fullName, "Invalid number"), false);
            return;
        } else if ("NULL".equalsIgnoreCase(fullName)) {
            if (!def.CanBeNull) throw new SyntaxError("NULL is forbidden here");
            this.codeItem.addVarArg(def, null);
            return;
        } else {
            Variable var = this.locateVar(fullName + (def.IsArray ? "[0]" : ""));
            if (var.type != def.Type) {
                throw new SyntaxError("Invalid variable type (" + fullName + "). Must be " + Variable.typeToString(def.Type));
            }
            if (var.block.readOnly && !def.IsReadOnly) {
                throw new SyntaxError("Read only variable (" + fullName + ") is forbidden here");
            }
            this.codeItem.addVarArg(def, var);
            if (!def.IsArray || !def.IsCheckedSize) return;
            this.codeItem.addNumArg(def, var.arrayItems.length, true);
        }
    }

    private ParseState parseSub(String token) throws SyntaxError {
        String name = token.toUpperCase();
        if (this.Subs.containsKey(name)) {
            throw new SyntaxError("Duplicate subprogram name: \"" + token + "\"");
        }
        this.openCodeBlock(new CodeBlock(token), this.device.CommandMap.get("RET"));
        this.Subs.put(name, this.codeBlock);
        return ParseState.CMD;
    }

    private ParseState parseSchedule(String token) throws SyntaxError {
        if (this.hasSchedule()) {
            this.schedule = this.Schedules.alloc(Program.decodeInt(token, "Invalid schedule number"));
        }
        return ParseState.SCHED_PARAM_NAME;
    }

    private ParseState parseScheduleParamName(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.scheduleParam = token;
        return ParseState.SCHED_PARAM_VALUE;
    }

    private ParseState parseScheduleParamValue(String token) throws SyntaxError {
        if (this.hasSchedule()) {
            this.schedule.setParam(this.scheduleParam, token, this);
        }
        return ParseState.SCHED_PARAM_NAME;
    }

    public static int decodeInt(String s, String errorPrefix) throws SyntaxError {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public static double decodeFloat(String s, String errorPrefix) throws SyntaxError {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public static int decodeIntRange(String s, String errorPrefix, int min, int max) throws SyntaxError {
        try {
            int v = Integer.decode(s);
            if (v < min || v > max) {
                throw new SyntaxError(errorPrefix + ": " + v + " out of range + (" + min + "..." + max + ")");
            }
            return v;
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public int getRamSize() {
        return this.RamVars.getSize();
    }

    public int getNvramSize() {
        return this.NvramVars.getSize();
    }

    public int getEepromSize() {
        return this.EepromVars.getSize();
    }

    public int getAllCodeSize() {
        int size = this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            size += cb.getSize();
        }
        return size;
    }

    public int getRamInitSize() {
        int size = 2;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            size += 3 + v.getSize();
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            size += 3 + v.getSize();
        }
        return size;
    }

    public int getHmiVarsSize() {
        this.menuVars.optimizeVars();
        return (this.menuVars.boolVars1.size() + this.menuVars.boolVars2.size() + this.menuVars.intVars.size() + this.menuVars.floatVars.size()) * 2;
    }

    public int getAlarmsCount() {
        int size = 0;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.alarm) continue;
            ++size;
        }
        return size;
    }

    public int getArchivedAlarmsCount() {
        int size = 0;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.alarm || !v.archived) continue;
            ++size;
        }
        return size;
    }

    public int getMenuSize() throws CompilerError {
        int size = 18;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.alarm) continue;
            size += MenuString.compiledSize(v.name);
        }
        this.mainMenu.compileStrings(this);
        this.menuStrings.setAddressInBlock(size += this.mainMenu.getSize());
        return size + this.menuStrings.getCompiledSize();
    }

    public int getConstantsSize() {
        return this.Constants.getSize();
    }

    public int getAllCommProfilesSize() {
        int s = 0;
        for (int i = 0; i < 3; ++i) {
            s += this.slaveProfiles[i].getFlashSize();
        }
        for (Port p : this.rs485Ports) {
            if (!p.hasMasterProfile()) continue;
            s += p.masterProfile.getFlashSize();
        }
        return s;
    }

    public int getFlashSize() throws CompilerError {
        int size = 155 + this.getAllCodeSize() + this.getRamInitSize() + this.getConstantsSize() + this.getHmiVarsSize() + this.getMenuSize() + this.getAllCommProfilesSize();
        return size;
    }

    private void CheckMemSize(int size, int max, String memType) throws ErrorInFile {
        if (size > max) {
            throw new ErrorInFile(memType + " overflow (" + size + " > " + max + ")");
        }
    }

    public static int fillByte(int b, byte[] buf, int offset) {
        buf[offset] = (byte)b;
        return offset + 1;
    }

    public static int fillWord(int w, byte[] buf, int offset) {
        buf[offset + 0] = (byte)w;
        buf[offset + 1] = (byte)(w >>> 8);
        return offset + 2;
    }

    public static int fillWord32(int w, byte[] buf, int offset) {
        buf[offset + 0] = (byte)w;
        buf[offset + 1] = (byte)(w >>> 8);
        buf[offset + 2] = (byte)(w >>> 16);
        buf[offset + 3] = (byte)(w >>> 24);
        return offset + 4;
    }

    public static int fillBytes(byte[] bytes, byte[] buf, int offset) {
        for (byte b : bytes) {
            buf[offset++] = b;
        }
        return offset;
    }

    private int fillValues(VariablesBlock vb, byte[] buf, int offset) {
        for (Variable v : vb.map.values()) {
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    protected int resolveLabel(String label, CodeBlock cb) throws SyntaxError {
        Integer addr = cb.Labels.get(label.toUpperCase());
        if (addr == null) {
            throw new SyntaxError("Unknown label: " + label);
        }
        return cb.startAddress + addr;
    }

    protected int resolveSub(String name) throws SyntaxError {
        CodeBlock sub = this.Subs.get(name.toUpperCase());
        if (sub == null) {
            throw new SyntaxError("Unknown subprogram: " + sub);
        }
        return sub.startAddress;
    }

    private int fillCode(CodeBlock cb, byte[] buf, int offset) throws SyntaxError {
        for (Command ci : cb.Items) {
            offset = Program.fillWord(ci.cmdDef.Code, buf, offset);
            for (Argument arg : ci.Args) {
                if (arg.Value == null) {
                    if (arg.def.CanBeNull) {
                        if (arg.Size == 1) {
                            offset = Program.fillByte(0, buf, offset);
                            continue;
                        }
                        offset = Program.fillWord(0, buf, offset);
                        continue;
                    }
                    throw new SyntaxError("Internal error. Arg cannot be NULL.");
                }
                if (arg.Type == 1) {
                    offset = Program.fillByte((byte)((Integer)arg.Value).intValue(), buf, offset);
                    continue;
                }
                if (arg.Type == 5) {
                    offset = Program.fillWord((Integer)arg.Value, buf, offset);
                    continue;
                }
                if (arg.Type == 2) {
                    offset = Program.fillWord(((Variable)arg.Value).getAddress(), buf, offset);
                    continue;
                }
                if (arg.Type == 3) {
                    offset = Program.fillWord(this.resolveLabel((String)arg.Value, cb), buf, offset);
                    continue;
                }
                if (arg.Type == 4) {
                    offset = Program.fillWord(this.resolveSub((String)arg.Value), buf, offset);
                    continue;
                }
                throw new SyntaxError("Internal error. Arg type=" + arg.Type);
            }
        }
        return offset;
    }

    private int fillHmiVars(byte[] buf, int offset) {
        for (Variable v : this.menuVars.boolVars1) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
        }
        for (Variable v : this.menuVars.boolVars2) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
        }
        for (Variable v : this.menuVars.intVars) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
        }
        for (Variable v : this.menuVars.floatVars) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
        }
        return offset;
    }

    private int fillMenuAndStrings(List<Variable> alarmVars, byte[] buf, int offset) throws CompilerError {
        if (this.menuVars.boolVars1.size() > 255) {
            throw new CompilerError("Too much visibility variables (max. 255)");
        }
        int startOffset = offset;
        offset += 8;
        offset = Program.fillWord(this.menuVars.boolVars1.size() + this.menuVars.boolVars2.size(), buf, offset);
        offset = Program.fillByte(this.menuVars.boolVars1.size(), buf, offset);
        offset = Program.fillWord(this.menuVars.intVars.size(), buf, offset);
        int alarmsCountOffset = offset = Program.fillWord(this.menuVars.floatVars.size(), buf, offset);
        offset += 3;
        int alarmsCount = 0;
        int archivedAlarmsCount = 0;
        int lastArchivedAlarmIndex = -1;
        for (Variable v : alarmVars) {
            if (!v.alarm) continue;
            ++alarmsCount;
            if (v.archived) {
                ++archivedAlarmsCount;
                ++lastArchivedAlarmIndex;
            }
            offset = MenuString.compileToCP866(v.name, buf, offset);
        }
        if (lastArchivedAlarmIndex != archivedAlarmsCount - 1) {
            throw new CompilerError("All archived alarms must be in the head of the list");
        }
        Program.fillWord(offset - startOffset - 6, buf, startOffset + 6);
        Program.fillWord(alarmsCount, buf, alarmsCountOffset);
        Program.fillByte(archivedAlarmsCount, buf, alarmsCountOffset + 2);
        offset = this.mainMenu.compile(this, buf, offset);
        for (int i = 0; i < this.menuStrings.getCompiledSize(); ++i) {
            offset = Program.fillByte(this.menuStrings.buffer[i], buf, offset);
        }
        int size = offset - startOffset;
        Program.fillWord(size, buf, startOffset + 0);
        Program.fillWord32(Program.calcFlashCRC32(this.flash, startOffset + 6, size - 6), buf, startOffset + 2);
        return offset;
    }

    public static int varTypeEncode(int type, int digits) throws SyntaxError {
        int res = 0;
        if (type == 2) {
            res = 1;
        } else if (type == 3) {
            if (digits == 0) {
                res = 2;
            } else if (digits == 1) {
                res = 3;
            } else if (digits == 2) {
                res = 4;
            } else if (digits == 3) {
                res = 5;
            } else {
                throw new SyntaxError("Invalid digits: " + digits);
            }
        }
        return res;
    }

    public static int digitsDecode(int encodedType) {
        if (encodedType == 3) {
            return 1;
        }
        if (encodedType == 4) {
            return 2;
        }
        if (encodedType == 5) {
            return 3;
        }
        return 0;
    }

    private int fillRamVar(Variable v, byte[] buf, int offset) {
        if (v.hasRamInitValue()) {
            offset = Program.fillWord(v.getAddress(), buf, offset);
            int type = 0;
            if (v.type == 2) {
                type = 1;
            } else if (v.type == 3) {
                type = 2;
            }
            offset = Program.fillByte((byte)type, buf, offset);
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    private int fillRamInit(byte[] buf, int offset) {
        int count = 0;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            ++count;
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasRamInitValue()) continue;
            ++count;
        }
        offset = Program.fillWord(count, buf, offset);
        for (Variable v : this.RamVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        return offset;
    }

    public void makeBinaryData() throws SyntaxError, ErrorInFile, CompilerError {
        int i;
        int i2;
        int i3;
        List<Variable> alarmVars = this.RamVars.reallocAlarms();
        this.MainCode.startAddress = 155;
        int addr = this.MainCode.startAddress + this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            cb.startAddress = addr;
            addr += cb.getSize();
        }
        this.codeFlashSize = addr - this.MainCode.startAddress;
        this.ramInitFlashSize = this.getRamInitSize();
        this.ramInitFlashAddress = this.ramInitFlashSize > 0 ? addr : 0;
        this.constantsFlashSize = this.getConstantsSize();
        this.constantsFlashAddress = this.constantsFlashSize > 0 ? (addr += this.ramInitFlashSize) : 0;
        this.hmiVarsFlashSize = this.getHmiVarsSize();
        this.hmiVarsFlashAddress = this.hmiVarsFlashSize > 0 ? (addr += this.constantsFlashSize) : 0;
        this.menuFlashSize = this.getMenuSize();
        this.menuFlashAddress = this.menuFlashSize > 0 ? (addr += this.hmiVarsFlashSize) : 0;
        addr += this.menuFlashSize;
        for (i3 = 0; i3 < 3; ++i3) {
            int size = this.slaveProfiles[i3].getFlashSize();
            this.slaveProfileFlashAddress[i3] = size > 0 ? addr : 0;
            addr += size;
        }
        this.masterProfileFlashAddress = new int[this.device.RS485count];
        for (i3 = 0; i3 < this.device.RS485count; ++i3) {
            Port port = this.rs485Ports[i3];
            int size = port.hasMasterProfile() ? port.masterProfile.getFlashSize() : 0;
            this.masterProfileFlashAddress[i3] = size > 0 ? addr : 0;
            addr += size;
        }
        int flashSize = this.getFlashSize();
        if (addr != flashSize) {
            throw new Error("Internal error #1 (" + addr + " != " + flashSize + ")");
        }
        this.Constants.startAddress = 49152;
        this.RamVars.startAddress = this.device.RamStart;
        this.NvramVars.startAddress = this.device.NvramStart;
        this.EepromVars.startAddress = this.device.EepromStart;
        this.CheckMemSize(flashSize, this.device.FlashSize, "ROM memory");
        this.CheckMemSize(this.getRamSize(), this.device.RamSize, "RAM");
        this.CheckMemSize(this.getEepromSize(), this.device.EepromSize, "EEPROM");
        this.CheckMemSize(this.getNvramSize(), this.device.NvramSize, "NVRAM");
        this.CheckMemSize(this.getAlarmsCount(), this.device.MaxAlarms, "Alarms");
        this.eeprom = new byte[this.getEepromSize()];
        this.fillValues(this.EepromVars, this.eeprom, 0);
        this.nvram = new byte[this.getNvramSize()];
        this.fillValues(this.NvramVars, this.nvram, 0);
        this.flash = new byte[flashSize];
        Arrays.fill(this.flash, (byte)-1);
        Program.fillByte(86, this.flash, 0);
        Program.fillByte(105, this.flash, 1);
        Program.fillByte(67, this.flash, 2);
        Program.fillByte(83, this.flash, 3);
        Program.fillWord(flashSize, this.flash, 4);
        Program.fillWord(this.device.Firmware * 100 + Version.release % 100, this.flash, 10);
        GregorianCalendar c = new GregorianCalendar();
        Program.fillByte(c.get(1) % 100, this.flash, 12);
        Program.fillByte(c.get(2) + 1, this.flash, 13);
        Program.fillByte(c.get(5), this.flash, 14);
        byte[] b = new byte[16];
        Arrays.fill(b, (byte)32);
        for (i2 = 0; i2 < Math.min(this.id.length(), 16); ++i2) {
            b[i2] = (byte)this.id.charAt(i2);
        }
        Program.fillBytes(b, this.flash, 15);
        Program.fillWord(this.eeprom.length, this.flash, 31);
        Program.fillWord(this.nvram.length, this.flash, 33);
        Program.fillWord(this.getRamSize(), this.flash, 35);
        Program.fillWord(6144, this.flash, 37);
        Program.fillWord(this.ramInitFlashAddress, this.flash, 39);
        Program.fillWord(this.constantsFlashAddress, this.flash, 41);
        Program.fillWord(0, this.flash, 43);
        Program.fillWord(this.hmiVarsFlashAddress, this.flash, 45);
        Program.fillWord(this.menuFlashAddress, this.flash, 47);
        for (i2 = 0; i2 < 8; ++i2) {
            Port p;
            int w = 0;
            int gw = 0;
            if (i2 < this.rs485Ports.length) {
                p = this.rs485Ports[i2];
                if (p.hasMasterProfile()) {
                    w = this.masterProfileFlashAddress[i2];
                } else if (p.slaveProfile != null) {
                    w = this.slaveProfileFlashAddress[p.slaveProfile.index];
                    gw = p.gatewayTargetRS485index;
                    if (gw < 0 || gw >= this.device.RS485count || this.rs485Ports[gw].masterProfile == null || gw == i2) {
                        gw = 255;
                    }
                }
            }
            Program.fillWord(w, this.flash, 49 + i2 * 2);
            Program.fillByte(gw, this.flash, 87 + i2);
            if (i2 < this.tcpSlavePorts.length) {
                p = this.tcpSlavePorts[i2];
                if (p.slaveProfile != null) {
                    w = this.slaveProfileFlashAddress[p.slaveProfile.index];
                }
            }
            Program.fillWord(w, this.flash, 69 + i2 * 2);
        }
        if (this.usbPort != null && this.usbPort.slaveProfile != null) {
            Program.fillWord(this.slaveProfileFlashAddress[this.usbPort.slaveProfile.index], this.flash, 65);
        } else {
            Program.fillWord(0, this.flash, 61);
        }
        Program.fillWord(this.slaveProfileFlashAddress[0], this.flash, 67);
        Program.fillWord(0, this.flash, 85);
        int offset = this.Schedules.compileData(this.flash, 95);
        if (offset != this.MainCode.startAddress) {
            throw new Error("Internal error: Invalid code address");
        }
        offset = this.fillCode(this.MainCode, this.flash, offset);
        for (CodeBlock cb : this.Subs.values()) {
            offset = this.fillCode(cb, this.flash, offset);
        }
        if (this.ramInitFlashAddress > 0) {
            if (offset != this.ramInitFlashAddress) {
                throw new Error("Internal error: Invalid RAM init address");
            }
            offset = this.fillRamInit(this.flash, offset);
        }
        if (this.constantsFlashAddress > 0) {
            if (offset != this.constantsFlashAddress) {
                throw new Error("Internal error: Invalid constants address");
            }
            offset = this.fillValues(this.Constants, this.flash, offset);
        }
        if (this.hmiVarsFlashAddress > 0) {
            if (offset != this.hmiVarsFlashAddress) {
                throw new Error("Internal error: Invalid HMI variables address");
            }
            offset = this.fillHmiVars(this.flash, offset);
        }
        if (this.menuFlashAddress > 0) {
            if (offset != this.menuFlashAddress) {
                throw new Error("Internal error: Invalid menu address");
            }
            offset = this.fillMenuAndStrings(alarmVars, this.flash, offset);
        }
        for (i = 0; i < this.slaveProfileFlashAddress.length; ++i) {
            if (this.slaveProfileFlashAddress[i] <= 0) continue;
            if (offset != this.slaveProfileFlashAddress[i]) {
                throw new Error("Internal error: Invalid SLAVE comm. profile " + (i + 1) + " address");
            }
            offset = this.slaveProfiles[i].fillFlash(this.flash, offset);
        }
        for (i = 0; i < this.masterProfileFlashAddress.length; ++i) {
            if (this.masterProfileFlashAddress[i] <= 0) continue;
            if (offset != this.masterProfileFlashAddress[i]) {
                throw new Error("Internal error: Invalid MASTER comm. profile " + (i + 1) + " address");
            }
            offset = this.rs485Ports[i].masterProfile.fillFlash(this.rs485Ports[i].isRs485TcpGateway, this.flash, offset);
        }
        if (offset != this.flash.length) {
            throw new Error("Internal error #2 (" + offset + " != " + this.flash.length + ")");
        }
        this.flashCRC = Program.calcFlashCRC32(this.flash, 10, this.flash.length - 10);
        Program.fillWord(this.flashCRC, this.flash, 6);
        Program.fillWord(this.flashCRC >>> 16, this.flash, 8);
    }

    public static int calcFlashCRC32(byte[] data, int addr, int size) {
        int crc = -1;
        int poly = -306674912;
        for (int i = 0; i < size; ++i) {
            int b = data[addr + i] & 0xFF;
            crc ^= b;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) != 0) {
                    crc = crc >>> 1 ^ poly;
                    continue;
                }
                crc >>>= 1;
            }
        }
        return ~crc;
    }

    public void dumpBinaryData(PrintWriter pw) {
        int i;
        pw.println(";---------------------- FLASH -----------------------------------------------------");
        pw.println();
        pw.println("; Total size: " + this.flash.length + " ($" + Integer.toHexString(this.flash.length) + "), CRC32: " + Integer.toHexString(this.flashCRC));
        pw.println("; Code at $" + Integer.toHexString(this.MainCode.startAddress) + ", size: " + this.codeFlashSize);
        pw.println("; RAM init at $" + Integer.toHexString(this.ramInitFlashAddress) + ", size: " + this.ramInitFlashSize);
        pw.println("; Constants at $" + Integer.toHexString(this.constantsFlashAddress) + ", size: " + this.constantsFlashSize);
        pw.println("; HMI variables at $" + Integer.toHexString(this.hmiVarsFlashAddress) + ", size: " + this.hmiVarsFlashSize);
        pw.println("; Menu at $" + Integer.toHexString(this.menuFlashAddress) + ", size: " + this.menuFlashSize);
        for (i = 0; i < this.slaveProfileFlashAddress.length; ++i) {
            if (this.slaveProfileFlashAddress[i] <= 0) continue;
            pw.println("; MODBUS slave profile " + (i + 1) + " at $" + Integer.toHexString(this.slaveProfileFlashAddress[i]) + ", size: " + this.slaveProfiles[i].getFlashSize());
        }
        for (i = 0; i < this.masterProfileFlashAddress.length; ++i) {
            if (this.masterProfileFlashAddress[i] <= 0) continue;
            pw.println("; MODBUS master profile for RS485 port " + (i + 1) + " at $" + Integer.toHexString(this.masterProfileFlashAddress[i]) + ", size: " + this.rs485Ports[i].masterProfile.getFlashSize());
        }
        pw.println(";");
        this.printBytes(this.flash, 0, ".db ", pw);
        pw.println();
        for (Variable v : this.Constants.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.fullName());
        }
        pw.println();
        pw.println(";------------------------------- EEPROM (Store) -----------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.EepromVars.startAddress) + ", size: " + this.eeprom.length);
        pw.println();
        this.printBytes(this.eeprom, this.EepromVars.startAddress, "; ", pw);
        pw.println();
        for (Variable v : this.EepromVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.fullName());
        }
        pw.println();
        pw.println(";------------------------------- NVRAM (Ext) --------------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.NvramVars.startAddress) + ", size: " + this.nvram.length);
        pw.println();
        this.printBytes(this.nvram, this.NvramVars.startAddress, "; ", pw);
        pw.println();
        for (Variable v : this.NvramVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.fullName());
        }
        pw.println();
        pw.println(";------------------------------- External EEPROM ----------------------------------");
        pw.println();
        if (this.hasSchedule()) {
            int block = 344;
            for (int i2 = 0; i2 < this.Schedules.items.length; ++i2) {
                Schedule s = this.Schedules.items[i2];
                if (s.var == null) continue;
                int start = this.device.ExtEepromScheduleStart + block * i2;
                pw.println("; Schedule " + (i2 + 1) + " at: $" + Integer.toHexString(start) + ", size: " + block);
                pw.println();
                this.printBytes(Arrays.copyOfRange(this.Schedules.eeprom, block * i2, block * (i2 + 1)), this.device.ExtEepromScheduleStart + block * i2, "; ", pw);
                pw.println();
                pw.println();
            }
        }
        pw.println();
        pw.println(";------------------------------- RAM variables ------------------------------------");
        pw.println();
        for (Variable v : this.RamVars.map.values()) {
            pw.println("; $" + Integer.toHexString(v.getAddress()) + ": " + v.fullName());
        }
    }

    protected static String byteToHex(int b) {
        return "$" + Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected static String byteToHex2(int b) {
        return Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected static String wordToHex2(int w) {
        return Program.byteToHex2(w >>> 8) + Program.byteToHex2(w);
    }

    private void printBytes(byte[] buf, int addr, String dataPrefix, PrintWriter pw) {
        int start = 0;
        int i = 0;
        String s = "";
        while (start + i < buf.length) {
            s = s.length() == 0 ? dataPrefix + Program.byteToHex(buf[start + i]) : s + ", " + Program.byteToHex(buf[start + i]);
            if (++i < 16 && start + i < buf.length) continue;
            pw.println("; $" + Program.wordToHex2(addr + start) + ":");
            pw.println(s);
            start += i;
            i = 0;
            s = "";
        }
    }

    private static void printHexRecord(PrintWriter pw, int addr16, int type, byte[] data) {
        byte count = (byte)data.length;
        byte addrHi = (byte)(addr16 >>> 8);
        byte addrLo = (byte)addr16;
        int sum = -(count + addrHi + addrLo + type);
        pw.print(":");
        pw.print(Program.byteToHex2(count));
        pw.print(Program.byteToHex2(addrHi));
        pw.print(Program.byteToHex2(addrLo));
        pw.print(Program.byteToHex2(type));
        for (byte b : data) {
            sum -= b;
            pw.print(Program.byteToHex2(b));
        }
        pw.println(Program.byteToHex2(sum));
    }

    private static void printHexHiAddr(PrintWriter pw, int hi16bit) {
        Program.printHexRecord(pw, 0, 4, new byte[]{(byte)(hi16bit >>> 8), (byte)hi16bit});
    }

    public void printFlashHex(PrintWriter pw, int flashStartAddr) {
        byte[] buf = this.flash;
        int pos = 0;
        int addr = flashStartAddr;
        int hi16bit = 0;
        while (pos < buf.length) {
            int size;
            if (addr >>> 16 != hi16bit) {
                hi16bit = addr >>> 16;
                Program.printHexHiAddr(pw, hi16bit);
            }
            for (size = 0; size < 16 && pos + size < buf.length && addr + size >>> 16 == hi16bit; ++size) {
            }
            Program.printHexRecord(pw, addr & 0xFFFF, 0, Arrays.copyOfRange(buf, pos, pos + size));
            pos += size;
            addr += size;
        }
        pw.println(":00000001FF");
    }

    public static class OldEditorError
    extends SyntaxError {
        private static final long serialVersionUID = 1L;

        public OldEditorError() {
            super("File was made by newer version of editor");
        }
    }

    static enum ParseState {
        PARSE_START,
        FILE_VERSION,
        PROG_ID,
        CODE_CRC,
        TARGET,
        BLOCK_BEGIN,
        VAR_NAME,
        VAR_VALUE,
        MODBUS_SLAVE_NAME,
        MODBUS_SLAVE_REG,
        MODBUS_SLAVE_VAR,
        MODBUS_SLAVE_K,
        MODBUS_SLAVE_K_VALUE,
        PORT_TYPE,
        PORT_RS485_INDEX,
        PORT_TCP_INDEX,
        PORT_RS485_TCPGW,
        PORT_MODE,
        PORT_SLAVE_PROFILE,
        PORT_RS485_SLAVE_GW,
        MODBUS_MASTER_TIMEOUT,
        MODBUS_MASTER_PAUSE,
        MODBUS_MASTER_VXMODULES,
        MODBUS_MASTER_REQUEST,
        MODBUS_MASTER_REQ_TYPE,
        MODBUS_MASTER_REQ_ID,
        MODBUS_MASTER_REQ_ADDR,
        MODBUS_MASTER_REQ_CMDVAR,
        MODBUS_MASTER_REQ_RESULTVAR,
        MODBUS_MASTER_REQ_ERRCOUNTVAR,
        MODBUS_MASTER_REGISTER,
        MODBUS_MASTER_REG_K,
        MODBUS_MASTER_REG_K_VALUE,
        CMD,
        CMD_ARG,
        SUB,
        MENUITEM,
        MENUITEM_VIS_ACCESS,
        MENUITEM_NAME,
        MENUITEM_VAR,
        MENUITEM_VAR_DIGITS,
        MENUITEM_VAR_RW,
        MENUITEM_VAR_MIN,
        MENUITEM_VAR_MAX,
        MENUITEM_VAR_STRINGS,
        SCHEDULE,
        SCHED_PARAM_NAME,
        SCHED_PARAM_VALUE,
        ARCHIVE_VAR,
        ARCHIVE_STRING1,
        ARCHIVE_STRING2,
        PARSE_END;

    }
}

