/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.ModbusMasterProfile;
import certa.vics.compiler.ModbusSlaveProfile;

public class Port {
    public final PortType type;
    public final int index;
    public boolean isRs485Master;
    public boolean isRs485TcpGateway;
    public ModbusMasterProfile masterProfile;
    public ModbusSlaveProfile slaveProfile;
    public int gatewayTargetRS485index = -1;

    public Port(PortType type, int index, ModbusSlaveProfile defSlaveProfile) {
        this.type = type;
        this.index = index;
        this.clear(defSlaveProfile);
    }

    public void clear(ModbusSlaveProfile defSlaveProfile) {
        this.masterProfile = null;
        this.slaveProfile = defSlaveProfile;
    }

    public boolean hasMasterProfile() {
        return this.isRs485Master && this.masterProfile != null;
    }

    public String toString() {
        if (this.type == PortType.RS485) {
            return "RS485_" + (this.index + 1);
        }
        if (this.type == PortType.TCP) {
            return "TCP_" + (this.index + 1);
        }
        if (this.type == PortType.USB) {
            return "USB_" + (this.index + 1);
        }
        return "???";
    }

    public static enum PortType {
        RS485,
        TCP,
        USB;

    }
}

