/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;

public class ModbusSlaveProfile {
    public static final int REG_INPUT = 1;
    public static final int REG_COIL = 2;
    public static final int REG_IR = 3;
    public static final int REG_HR = 4;
    public final ArrayList<ModbusReg> Inputs = new ArrayList();
    public final ArrayList<ModbusReg> Coils = new ArrayList();
    public final ArrayList<ModbusReg> IRs = new ArrayList();
    public final ArrayList<ModbusReg> HRs = new ArrayList();
    ModbusReg dumb;
    public final int index;

    public ModbusSlaveProfile(int index) {
        this.index = index;
    }

    public void clear(Variable dumb) {
        this.Inputs.clear();
        this.Coils.clear();
        this.IRs.clear();
        this.HRs.clear();
        this.dumb = new ModbusReg(dumb, 0);
    }

    public boolean isEmpty(ModbusReg reg) {
        return reg == null || reg == this.dumb;
    }

    public void alloc(int regType, int regAddress, Variable var, int digits) throws SyntaxError {
        if (regType == 1) {
            this.allocInput(var, regAddress);
        } else if (regType == 2) {
            this.allocCoil(var, regAddress);
        } else if (regType == 3) {
            this.allocIR(var, regAddress, digits);
        } else if (regType == 4) {
            this.allocHR(var, regAddress, digits);
        } else {
            throw new SyntaxError("Unknown regType: " + regType);
        }
    }

    public void allocInput(Variable var, int regAddress) throws SyntaxError {
        this.allocDiscrete(var, regAddress, this.Inputs, "Input");
    }

    public void allocCoil(Variable var, int regAddress) throws SyntaxError {
        this.allocDiscrete(var, regAddress, this.Coils, "Coil");
    }

    public void allocIR(Variable var, int regAddress, int digits) throws SyntaxError {
        this.allocAnalog(var, regAddress, digits, this.IRs, "IR");
    }

    public void allocHR(Variable var, int regAddress, int digits) throws SyntaxError {
        this.allocAnalog(var, regAddress, digits, this.HRs, "HR");
    }

    private void allocDiscrete(Variable var, int addr, ArrayList<ModbusReg> list, String regType) throws SyntaxError {
        if (var != null && var.type != 1) {
            throw new SyntaxError("Invalid variable type for " + regType + " (must be bool)");
        }
        this.allocReg(var, addr, 0, list, regType);
    }

    private void allocAnalog(Variable var, int addr, int digits, ArrayList<ModbusReg> list, String regType) throws SyntaxError {
        if (var != null) {
            if (var.type == 3) {
                if (digits < 0 || digits > 3) {
                    throw new SyntaxError("Invalid " + regType + " digits: " + digits + " (must be 0..3)");
                }
            } else {
                digits = 0;
            }
        }
        this.allocReg(var, addr, digits, list, regType);
    }

    private void allocReg(Variable var, int addr, int digits, ArrayList<ModbusReg> list, String regType) throws SyntaxError {
        if (addr < 0 || addr > 65535) {
            throw new IndexOutOfBoundsException("Invalid " + regType + " address: " + addr);
        }
        list.ensureCapacity(addr + 1);
        for (int i = list.size(); i <= addr; ++i) {
            list.add(this.dumb);
        }
        ModbusReg r = list.get(addr);
        if (!this.isEmpty(r)) {
            throw new SyntaxError("Modbus " + regType + "" + addr + " already linked with \"" + r.var.fullName() + "\"");
        }
        if (var != null) {
            list.set(addr, new ModbusReg(var, digits));
        }
    }

    public int getFlashSize() {
        return 9 + this.Coils.size() * 2 + this.Inputs.size() * 2 + this.HRs.size() * 3 + this.IRs.size() * 3;
    }

    private int fillModbusClientTable(ArrayList<ModbusReg> list, boolean withType, byte[] buf, int offset) throws SyntaxError {
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            int addr = 0;
            int type = 0;
            if (r != null) {
                addr = r.var.getAddress();
                type = Program.varTypeEncode(r.var.type, r.digits);
            }
            offset = Program.fillWord(addr, buf, offset);
            if (!withType) continue;
            offset = Program.fillByte((byte)type, buf, offset);
        }
        return offset;
    }

    public int fillFlash(byte[] buf, int offset) throws SyntaxError {
        offset = Program.fillByte(0, buf, offset);
        offset = Program.fillWord(this.Coils.size(), buf, offset);
        offset = Program.fillWord(this.Inputs.size(), buf, offset);
        offset = Program.fillWord(this.HRs.size(), buf, offset);
        offset = Program.fillWord(this.IRs.size(), buf, offset);
        offset = this.fillModbusClientTable(this.Coils, false, buf, offset);
        offset = this.fillModbusClientTable(this.Inputs, false, buf, offset);
        offset = this.fillModbusClientTable(this.HRs, true, buf, offset);
        offset = this.fillModbusClientTable(this.IRs, true, buf, offset);
        return offset;
    }

    public void allocUnresolved(int regType, int regAddress, String var, int digits) throws SyntaxError {
        if (regType == 1) {
            this.allocRegUnres(var, regAddress, 0, this.Inputs, "Input");
        } else if (regType == 2) {
            this.allocRegUnres(var, regAddress, 0, this.Coils, "Coil");
        } else if (regType == 3) {
            this.allocRegUnres(var, regAddress, digits, this.IRs, "IR");
        } else if (regType == 4) {
            this.allocRegUnres(var, regAddress, digits, this.HRs, "HR");
        } else {
            throw new SyntaxError("Unknown regType: " + regType);
        }
    }

    private void allocRegUnres(String var, int addr, int digits, ArrayList<ModbusReg> list, String regType) throws SyntaxError {
        if (addr < 0 || addr > 65535) {
            throw new IndexOutOfBoundsException("Invalid " + regType + " address: " + addr);
        }
        list.ensureCapacity(addr + 1);
        for (int i = list.size(); i <= addr; ++i) {
            list.add(this.dumb);
        }
        ModbusReg r = list.get(addr);
        if (!this.isEmpty(r)) {
            throw new SyntaxError("Modbus " + regType + "" + addr + " already linked with \"" + r.varStr + "\"");
        }
        if (var != null) {
            list.set(addr, new ModbusReg(var, digits));
        }
    }

    protected void resolveLinks(Program prg) throws SyntaxError {
        int i = 0;
        for (ModbusReg r : this.Inputs) {
            r.resolve("Input" + i++, prg);
        }
        i = 0;
        for (ModbusReg r : this.Coils) {
            r.resolve("Coil" + i++, prg);
        }
        i = 0;
        for (ModbusReg r : this.IRs) {
            r.resolve("IR" + i++, prg);
        }
        i = 0;
        for (ModbusReg r : this.HRs) {
            r.resolve("HR" + i++, prg);
        }
    }
}

