/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.MenuString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MenuStringsBuffer {
    public final byte[] buffer = new byte[65536];
    private int bufSize = 0;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private int address = 0;

    public int getAddress() {
        return this.address;
    }

    public void setAddressInBlock(int address) {
        this.address = address;
    }

    public void clear() {
        this.map.clear();
        this.bufSize = 0;
    }

    public int getCompiledSize() {
        return this.bufSize;
    }

    public void compileStrings(List<String> list) throws CompilerError {
        String key = "";
        for (String s : list) {
            key = key + s;
        }
        if (Utils.strEmpty(key)) {
            throw new CompilerError("Cannot compile empty string list");
        }
        Integer offset = this.map.get(key);
        if (offset == null) {
            offset = this.bufSize;
            int pos = offset;
            for (String s : list) {
                pos = MenuString.compileToCP866(s, this.buffer, pos);
            }
            this.bufSize += pos - offset;
            this.map.put(key, offset);
        }
    }

    public void compileString(String str) throws CompilerError {
        if (Utils.strEmpty(str)) {
            return;
        }
        Integer offset = this.map.get(str);
        if (offset == null) {
            offset = this.bufSize;
            int pos = MenuString.compileToCP866(str, this.buffer, offset);
            this.bufSize += pos - offset;
            this.map.put(str, offset);
        }
    }

    public int getStringsAddress(List<String> list) throws CompilerError {
        String key = "";
        for (String s : list) {
            key = key + s;
        }
        Integer offset = this.map.get(key);
        if (offset == null) {
            throw new CompilerError("Error in getStringsAddress()");
        }
        return this.address + offset;
    }

    public int getStringAddress(String str) throws CompilerError {
        Integer offset = this.map.get(str);
        if (offset == null) {
            return 0;
        }
        return this.address + offset;
    }
}

