/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;

public abstract class AMenuItem {
    public int startAddress;
    public final MenuItemMenu parent;
    private int access;
    private String name;
    private String visibleVarName;
    private Variable visibleVar;

    public AMenuItem(MenuItemMenu parent, Variable visibleVar, int access, String name) {
        this.parent = parent;
        this.access = access;
        this.visibleVar = visibleVar;
        this.name = name;
        if (parent != null) {
            parent.items.add(this);
        }
    }

    public int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getVisibleVarName() {
        return this.visibleVarName;
    }

    public void setVisibleVarName(String varName) {
        this.visibleVarName = varName;
    }

    public Variable getVisibleVar() {
        return this.visibleVar;
    }

    public void setVisibleVar(Variable variable) {
        this.visibleVar = variable;
    }

    public void clear() {
    }

    public void resolveLinks(Program program) throws SyntaxError {
        if (this.visibleVar == null && !Utils.strEmpty(this.visibleVarName)) {
            this.visibleVar = program.locateVar(this.visibleVarName);
        }
        if (this.visibleVar != null) {
            program.menuVars.addVar(this.visibleVar, true);
        }
    }

    public final int getHeaderSize() {
        return 6;
    }

    public abstract int getSize();

    public abstract int getBinaryType();

    public void compileStrings(Program prg) throws CompilerError {
        prg.menuStrings.compileString(this.getDisplayName());
    }

    public int compile(Program prg, byte[] buffer, int offset) throws CompilerError {
        int size = this.getSize();
        if (buffer != null) {
            buffer[offset + 0] = (byte)((this.access & 3) << 6 | this.getBinaryType() & 0x3F);
            buffer[offset + 1] = (byte)size;
            buffer[offset + 2] = (byte)(size >> 8);
            int t = prg.menuStrings.getStringAddress(this.getDisplayName());
            buffer[offset + 3] = (byte)t;
            buffer[offset + 4] = (byte)(t >> 8);
            buffer[offset + 5] = (byte)prg.menuVars.getVisibilityVarIndex(this.visibleVar);
        }
        return offset + size;
    }
}

