/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.ModbusPdu;
import certa.modbus.server.DefaultRequestProcessor;
import certa.modbus.server.ModbusWriteHandler;
import certa.modbus.server.RegistersTable;
import certa.modbus.server.RequestProcessor;
import org.slf4j.Logger;

public abstract class AModbusServer {
    public final RegistersTable inputs;
    public final RegistersTable coils;
    public final RegistersTable iregs;
    public final RegistersTable hregs;
    public final RequestProcessor processor;
    final Logger log = this.getLog();
    protected ModbusWriteHandler handler;

    public AModbusServer(int inputsStart, int inputsCount, int coilsStart, int coilsCount, int iregsStart, int iregsCount, int hregsStart, int hregsCount, RequestProcessor processor) {
        this.inputs = new RegistersTable(inputsStart, inputsCount);
        this.coils = new RegistersTable(coilsStart, coilsCount);
        this.iregs = new RegistersTable(iregsStart, iregsCount);
        this.hregs = new RegistersTable(hregsStart, hregsCount);
        this.processor = processor != null ? processor : new DefaultRequestProcessor(this);
    }

    public void setWriteHandler(ModbusWriteHandler handler) {
        this.handler = handler;
    }

    public void logData(String prefix, byte[] buffer, int start, int length) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(prefix + ModbusPdu.toHex(buffer, start, length));
        }
    }

    protected abstract Logger getLog();

    public abstract void Start();

    public abstract void Stop();
}

