/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.AbstractRtuTransport;
import certa.modbus.client.ModbusClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.slf4j.LoggerFactory;

public class RtuOverTcpTransport
extends AbstractRtuTransport {
    private final String remoteAddressString;
    private final int remotePort;
    private final String localAddressString;
    private final int localPort;
    private final int connectTimeout;
    private Socket socket;

    public RtuOverTcpTransport(String remoteHost, int remotePort, String localIP, int localPort, int connectTimeout, int responseTimeout, int pause, boolean keepConnection) {
        super(responseTimeout, pause, keepConnection, LoggerFactory.getLogger(RtuOverTcpTransport.class));
        this.remoteAddressString = remoteHost;
        this.remotePort = remotePort;
        this.localAddressString = localIP != null ? localIP : "0.0.0.0";
        this.localPort = localPort;
        this.connectTimeout = connectTimeout;
    }

    public String toString() {
        return "RTU over TCP " + this.remoteAddressString + ":" + this.remotePort;
    }

    @Override
    public int changeTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            this.log.error("changeTimeout() error", e);
        }
        int t = this.timeout;
        this.timeout = timeout;
        return t;
    }

    @Override
    protected synchronized boolean openPort() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            this.log.info("Opening socket: {}:{} <-> {}:{}, respTO: {}, connTO: {}, pause: {}", this.localAddressString, this.localPort, this.remoteAddressString, this.remotePort, this.timeout, this.connectTimeout, this.pause);
            InetSocketAddress localAddress = this.localAddressString == null || this.localAddressString.isEmpty() ? null : new InetSocketAddress(InetAddress.getByName(this.localAddressString), this.localPort);
            InetSocketAddress remoteAddress = new InetSocketAddress(InetAddress.getByName(this.remoteAddressString), this.remotePort);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                this.log.error("Error opening socket {} (sleep: {}", (Object)remoteAddress, (Object)e1);
            }
            this.socket = new Socket();
            try {
                this.socket.setSoLinger(true, 0);
                this.socket.bind(localAddress);
                this.socket.connect(remoteAddress, this.connectTimeout);
                this.socket.setSoTimeout(this.timeout);
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            this.log.info("Socket opened: {} <-> {}", (Object)this.socket.getLocalSocketAddress(), (Object)this.socket.getRemoteSocketAddress());
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.log.info("Closing socket");
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.log.error("Error closing socket {}: {}", (Object)this.socket.getRemoteSocketAddress(), (Object)e);
            }
            this.log.info("Socket closed");
        }
    }

    @Override
    protected void clearInput() throws IOException {
        InputStream in = this.socket.getInputStream();
        int avail = in.available();
        while (avail > 0) {
            int count = Math.min(avail, this.buffer.length);
            in.read(this.buffer, 0, count);
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(this.buffer, 0, count));
            }
            avail = in.available();
        }
    }

    @Override
    protected void sendData(int size) throws IOException {
        this.socket.getOutputStream().write(this.buffer, 0, size);
    }

    @Override
    protected boolean readToBuffer(int start, int length, ModbusClient modbusClient) throws IOException {
        int res;
        InputStream in = this.socket.getInputStream();
        long now = System.currentTimeMillis();
        long deadline = now + (long)this.timeout;
        int offset = start;
        int bytesToRead = length;
        while (now < deadline && bytesToRead > 0) {
            try {
                res = in.read(this.buffer, offset, bytesToRead);
            }
            catch (SocketTimeoutException e) {
                res = 0;
                this.log.debug("readToBuffer(): SocketTimeoutException");
            }
            if (res < 0) {
                throw new IOException("Socket's InputStream is at End Of File");
            }
            offset += res;
            if ((bytesToRead -= res) <= 0) continue;
            now = System.currentTimeMillis();
        }
        res = length - bytesToRead;
        if (res < length) {
            if (res > 0 && this.log.isTraceEnabled()) {
                this.log.trace("Read (incomplete): " + ModbusPdu.toHex(this.buffer, 0, start + res));
            }
            this.log.warn("Response timeout ({} bytes, need {})", (Object)(start + res), (Object)this.expectedBytes);
            return false;
        }
        return true;
    }
}

