/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtuOverMqttTransport
implements ModbusClientTransport,
MqttCallbackExtended {
    static final int PAUSE = 100;
    static final int TIMEOUT = 5000;
    static final int QOS = 0;
    final Logger log = LoggerFactory.getLogger(RtuOverMqttTransport.class);
    private volatile byte[] inputData = null;
    private final String brokerURI;
    private final String clientId;
    private final String login;
    private final String password;
    private final String requestTopic;
    private final String responseTopic;
    private MqttClient mqttClient = null;
    private final MemoryPersistence persistence = new MemoryPersistence();

    public RtuOverMqttTransport(String brokerHost, int brokerPort, String clientId, String login, String password, String gateCid) {
        this.brokerURI = "tcp://" + brokerHost + ":" + brokerPort;
        this.clientId = clientId;
        this.login = login;
        this.password = password;
        this.requestTopic = gateCid + "/sys/bridge_uart/request";
        this.responseTopic = gateCid + "/sys/bridge_uart/response";
    }

    @Override
    public int changeTimeout(int timeout) {
        return 5000;
    }

    private void openConnection() throws Exception {
        if (this.mqttClient == null) {
            this.mqttClient = new MqttClient(this.brokerURI, this.clientId, this.persistence);
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(true);
            connOpts.setAutomaticReconnect(true);
            connOpts.setUserName(this.login);
            connOpts.setPassword(this.password.toCharArray());
            this.log.debug("Connecting to broker: {}", (Object)this.brokerURI);
            this.mqttClient.setCallback(this);
            this.mqttClient.connect(connOpts);
            this.log.debug("Subscribing topic {}", (Object)this.responseTopic);
            this.mqttClient.subscribe(this.responseTopic);
        }
    }

    @Override
    public void sendRequest(ModbusClient modbusClient) throws Exception, InterruptedException {
        Thread.sleep(100L);
        this.openConnection();
        int size = modbusClient.getPduSize() + 3;
        byte[] buf = new byte[size];
        buf[0] = modbusClient.getServerId();
        modbusClient.readFromPdu(0, modbusClient.getPduSize(), buf, 1);
        int crc = ModbusPdu.calcCRC16(buf, 0, size - 2);
        buf[size - 2] = ModbusPdu.lowByte(crc);
        buf[size - 1] = ModbusPdu.highByte(crc);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Write: " + ModbusPdu.toHex(buf, 0, size));
        }
        this.mqttClient.publish(this.requestTopic, buf, 0, false);
    }

    protected boolean crcValid(byte[] buffer, int size) {
        int crc2;
        int crc = ModbusPdu.calcCRC16(buffer, 0, size);
        if (crc == (crc2 = ModbusPdu.bytesToInt16(buffer[size], buffer[size + 1], true))) {
            return true;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("CRC error (calc: {}, in response: {})", (Object)Integer.toHexString(crc), (Object)Integer.toHexString(crc2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        if (this.mqttClient == null) {
            return 1;
        }
        long deadline = System.currentTimeMillis() + 5000L;
        byte[] data = null;
        do {
            RtuOverMqttTransport rtuOverMqttTransport = this;
            synchronized (rtuOverMqttTransport) {
                data = this.inputData;
                this.inputData = null;
            }
        } while (data == null && System.currentTimeMillis() < deadline);
        if (data == null) {
            return 1;
        }
        int expectedBytes = modbusClient.getExpectedPduSize() + 3;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Read (size={}): {}", (Object)data.length, (Object)ModbusPdu.toHex(data, 0, data.length));
        }
        if (data.length < 5) {
            return 1;
        }
        if (data[0] != modbusClient.getServerId()) {
            this.log.warn("waitResponse(): Invalid id: {} (expected: {})", (Object)data[0], (Object)modbusClient.getServerId());
            return 3;
        }
        if ((data[1] & 0x7F) != modbusClient.getFunction()) {
            this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)data[1], (Object)modbusClient.getFunction());
            return 3;
        }
        if ((data[1] & 0x80) != 0) {
            expectedBytes = 5;
            if (this.crcValid(data, 3)) {
                this.log.warn("waitResponse(): Modbus exception: {}", (Object)data[2]);
                modbusClient.setPduSize(2);
                modbusClient.writeToPdu(data, 1, modbusClient.getPduSize(), 0);
                return 2;
            }
            return 3;
        }
        if (data.length < expectedBytes) {
            this.log.warn("waitResponse(): Not enough data (expected: {})", (Object)expectedBytes);
            return 1;
        }
        if (this.crcValid(data, 1 + modbusClient.getExpectedPduSize())) {
            modbusClient.setPduSize(modbusClient.getExpectedPduSize());
            modbusClient.writeToPdu(data, 1, modbusClient.getPduSize(), 0);
            return 0;
        }
        return 3;
    }

    @Override
    public void close() {
        if (this.mqttClient != null) {
            try {
                this.mqttClient.disconnect(10000L);
            }
            catch (MqttException e) {
                this.log.error("disconnect() error", e);
            }
            try {
                this.mqttClient.close();
            }
            catch (MqttException e) {
                this.log.error("close() error", e);
            }
            this.mqttClient = null;
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        this.log.error("connectionLost", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (topic.equals(this.responseTopic)) {
            RtuOverMqttTransport rtuOverMqttTransport = this;
            synchronized (rtuOverMqttTransport) {
                this.inputData = message.getPayload();
            }
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    @Override
    public void connectComplete(boolean reconnect, String serverURI) {
    }
}

