/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus;

public class ModbusPdu {
    protected final byte[] pdu = new byte[253];
    protected int pduSize;
    private static final int[] CrcTable = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    public static final String toHex(byte[] data, int offset, int length) {
        if (data.length == 0 || offset > data.length || length < offset) {
            return "";
        }
        length = Math.min(data.length - offset, length);
        StringBuffer buf = new StringBuffer(length * 3);
        for (int i = 0; i < length; ++i) {
            int b = data[i + offset] & 0xFF;
            buf.append(Integer.toHexString(b >>> 4));
            buf.append(Integer.toHexString(b & 0xF));
            if (i >= length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static final String byteToHex(byte b) {
        int t = b & 0xFF;
        return Integer.toHexString(t >>> 4) + Integer.toHexString(t & 0xF);
    }

    public static final int calcCRC16(byte[] data, int offset, int length) {
        int crc = 65535;
        for (int i = 0; i < length; ++i) {
            crc = crc >>> 8 ^ CrcTable[(crc ^ data[offset + i]) & 0xFF];
        }
        return crc;
    }

    public static final int bytesToInt16(byte lowByte, byte highByte, boolean unsigned) {
        int i = highByte << 8 | lowByte & 0xFF;
        if (unsigned) {
            return i & 0xFFFF;
        }
        return i;
    }

    public static final int bytesToInt32(byte byte0, byte byte1, byte byte2, byte byte3) {
        return (byte3 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte1 & 0xFF) << 8 | byte0 & 0xFF;
    }

    public static final int ints16ToInt32(int lowInt16, int highInt16) {
        return highInt16 << 16 | lowInt16 & 0xFFFF;
    }

    public static final float ints16ToFloat(int lowInt16, int highInt16) {
        return Float.intBitsToFloat(ModbusPdu.ints16ToInt32(lowInt16, highInt16));
    }

    public static final byte highByte(int int16) {
        return (byte)(int16 >>> 8);
    }

    public static final byte lowByte(int int16) {
        return (byte)int16;
    }

    public static final int highInt16(int int32) {
        return int32 >> 16;
    }

    public static final int lowInt16(int int32) {
        return (int32 & 0xFFFF) << 16 >> 16;
    }

    public static final boolean[] int16ToBits(int int16) {
        boolean[] bits = new boolean[16];
        int i = 0;
        while (i < 16) {
            bits[i] = (int16 & 1) != 0;
            ++i;
            int16 >>= 1;
        }
        return bits;
    }

    public static final int bytesCount(int bitsCount) {
        int bytes = bitsCount / 8;
        if (bitsCount % 8 != 0) {
            ++bytes;
        }
        return bytes;
    }

    public void setPduSize(int size) {
        if (size < 1 || size > 253) {
            throw new IllegalArgumentException("Invalid PDU size: " + size);
        }
        this.pduSize = size;
    }

    public int getPduSize() {
        return this.pduSize;
    }

    public int getFunction() {
        return this.readByteFromPDU(0, true);
    }

    public void setFunction(int code) {
        this.writeByteToPDU(0, (byte)code);
    }

    public void readFromPdu(int pduOffset, int size, byte[] dest, int destOffset) {
        System.arraycopy(this.pdu, pduOffset, dest, destOffset, size);
    }

    public void writeToPdu(byte[] src, int srcOffset, int size, int pduOffset) {
        System.arraycopy(src, srcOffset, this.pdu, pduOffset, size);
    }

    public void writeByteToPDU(int offset, byte value) {
        if (offset < 0 || offset >= this.pduSize) {
            throw new IndexOutOfBoundsException();
        }
        this.pdu[offset] = value;
    }

    public void writeInt16ToPDU(int offset, int value) {
        if (offset < 1 || offset >= this.pduSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.pdu[offset] = ModbusPdu.highByte(value);
        this.pdu[offset + 1] = ModbusPdu.lowByte(value);
    }

    public void writeBitToPDU(int firstByte, int bitOffset, boolean value) {
        int offset = firstByte + bitOffset / 8;
        byte b = this.readByteFromPDU(offset);
        b = value ? (byte)(b | 1 << bitOffset % 8) : (byte)(b & ~(1 << bitOffset % 8));
        this.writeByteToPDU(offset, b);
    }

    public int readByteFromPDU(int offset, boolean unsigned) {
        if (unsigned) {
            return this.readByteFromPDU(offset) & 0xFF;
        }
        return this.readByteFromPDU(offset);
    }

    public byte readByteFromPDU(int offset) {
        if (offset < 0 || offset >= this.pduSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.pdu[offset];
    }

    public int readInt16FromPDU(int offset, boolean unsigned) {
        if (offset < 1 || offset >= this.pduSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        return ModbusPdu.bytesToInt16(this.pdu[offset + 1], this.pdu[offset], unsigned);
    }

    protected int readInt32FromPDU(int offset, boolean bigEndian) {
        if (bigEndian) {
            return ModbusPdu.ints16ToInt32(this.readInt16FromPDU(offset + 2, false), this.readInt16FromPDU(offset, false));
        }
        return ModbusPdu.ints16ToInt32(this.readInt16FromPDU(offset, false), this.readInt16FromPDU(offset + 2, false));
    }

    protected float readFloatFromPDU(int offset, boolean bigEndian) {
        return Float.intBitsToFloat(this.readInt32FromPDU(offset, bigEndian));
    }

    public boolean readBitFromPDU(int firstByte, int bitOffset) {
        byte b = this.readByteFromPDU(firstByte + bitOffset / 8);
        return (b & 1 << bitOffset % 8) != 0;
    }
}

