/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FontScanner
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static String imgFileName;
    private static String destFileName;
    private BufferedImage image;
    private JPanel canvas;
    static final int IMG_WIDTH = 1060;
    static final int IMG_HEIGHT = 1540;
    static final int X0 = 10;
    static final int Y0 = 10;
    static final double DOT_STEP_X = 13.0;
    static final double DOT_STEP_Y = 11.0;
    static final double CHAR_STEP_X = 5.4;
    static final double CHAR_STEP_Y = 8.2;
    static final int CHAR_WIDTH = 5;
    static final int CHAR_HEIGHT = 8;
    static final int COLUMNS_CNT = 15;
    static final int ROWS_CNT = 16;
    static final int FIRST_CHAR_CODE = 16;
    final boolean[][][] charData = new boolean[256][8][5];

    public FontScanner() {
        try {
            this.image = ImageIO.read(new File(imgFileName));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        this.canvas = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(FontScanner.this.image, 0, 0, null);
            }
        };
        this.canvas.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        JScrollPane sp = new JScrollPane(this.canvas);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportFile() throws Exception {
        for (int col = 0; col < 15; ++col) {
            for (int row = 0; row < 16; ++row) {
                for (int cy = 0; cy < 8; ++cy) {
                    for (int cx = 0; cx < 5; ++cx) {
                        int px = (int)(10.0 + 5.4 * (double)col + 13.0 * (double)(5 * col + cx));
                        int py = (int)(10.0 + 8.2 * (double)row + 11.0 * (double)(8 * row + cy));
                        int color = this.image.getRGB(px, py);
                        int code = 16 + 16 * col + row;
                        if (code > this.charData.length) {
                            throw new Exception("Invalid character code: " + code);
                        }
                        this.charData[code][cy][cx] = color != -1;
                        this.image.setRGB(px, py, ~color);
                    }
                }
            }
        }
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(destFileName), "UTF-8");){
            int height = this.charData[0].length;
            int width = this.charData[0][0].length;
            for (int code = 0; code < this.charData.length; ++code) {
                w.write("{ // 0x" + (code < 16 ? "0" : "") + Integer.toHexString(code) + "\n");
                for (int y = 0; y < height; ++y) {
                    w.write("{");
                    for (int x = 0; x < width; ++x) {
                        boolean b = this.charData[code][y][x];
                        w.write(b ? " true" : "false");
                        if (x < width - 1) {
                            w.write(", ");
                            continue;
                        }
                        w.write("}" + (y < height - 1 ? "," : "") + "\n");
                    }
                }
                w.write("}" + (code < this.charData.length - 1 ? "," : "") + "\n");
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Command line parameters: <image_file> <dest_file>");
            System.out.println("");
            System.out.println("Image file must be PNG with black/wite palette");
            return;
        }
        imgFileName = args[0];
        destFileName = args[1];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FontScanner");
                FontScanner panel = new FontScanner();
                frame.setDefaultCloseOperation(3);
                frame.setContentPane(panel);
                frame.setSize(800, 600);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                try {
                    panel.exportFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
    }
}

