/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.lcd;

import certa.vics.lcd.LcdFont;
import certa.vics.lcd.fonts.Cyrillic5x8;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class LcdDisplay
extends JComponent {
    private static final long serialVersionUID = 1L;
    public final LcdParams params = new LcdParams();
    protected byte[][] chars;

    public byte[][] getCharsBuffer() {
        return this.chars;
    }

    public LcdDisplay(LcdFont font, int columns, int rows) {
        this.params.font = font;
        this.setLcdSize(columns, rows);
    }

    public void setLcdSize(int columns, int rows) {
        this.params.columnsCount = columns;
        this.params.rowsCount = rows;
        byte[][] old = this.chars;
        this.chars = new byte[rows][columns];
        this.updateSize();
        this.clearAll();
        if (old != null) {
            for (int i = 0; i < Math.min(old.length, this.chars.length); ++i) {
                for (int j = 0; j < Math.min(old[i].length, this.chars[i].length); ++j) {
                    this.chars[i][j] = old[i][j];
                }
            }
        }
    }

    public LcdFont getLcdFont() {
        return this.params.font;
    }

    public void setLcdFont(LcdFont font) {
        this.params.font = font;
        this.updateSize();
    }

    public void updateSize() {
        Border b = this.getBorder();
        Insets i = b != null ? b.getBorderInsets(this) : null;
        int dx = 0;
        int dy = 0;
        this.params.x0 = 0;
        this.params.y0 = 0;
        if (i != null) {
            dx += i.right;
            dy += i.bottom;
            this.params.x0 = i.left;
            this.params.y0 = i.top;
        }
        Dimension d = new Dimension(LcdDisplay.getCharX0(this.params, this.params.columnsCount) + dx, LcdDisplay.getCharY0(this.params, this.params.rowsCount) + dy);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setSize(d);
    }

    public void clearLine(int rowIndex) {
        Arrays.fill(this.chars[rowIndex], (byte)32);
    }

    public void clearAll() {
        for (int i = 0; i < this.chars.length; ++i) {
            this.clearLine(i);
        }
    }

    public void setText(int rowIndex, String text) {
        if (this.params.font != null && rowIndex >= 0 && rowIndex < this.chars.length) {
            this.params.font.encodeString(text, this.chars[rowIndex]);
            this.repaint();
        }
    }

    public String getText(int rowIndex) {
        if (this.params.font != null && rowIndex >= 0 && rowIndex < this.chars.length) {
            return this.params.font.decodeString(this.chars[rowIndex]);
        }
        return null;
    }

    public void setCode(int columnIndex, int rowIndex, byte code) {
        if (rowIndex >= 0 && rowIndex < this.chars.length && columnIndex >= 0 && columnIndex < this.chars[0].length) {
            this.chars[rowIndex][columnIndex] = code;
            this.repaint();
        }
    }

    public byte getCode(int columnIndex, int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.chars.length && columnIndex >= 0 && columnIndex < this.chars[0].length) {
            return this.chars[rowIndex][columnIndex];
        }
        if (this.params.font != null) {
            return this.params.font.utf8CharToByte(' ');
        }
        return 0;
    }

    public int getColumnsCount() {
        return this.chars[0].length;
    }

    public int getRowsCount() {
        return this.chars.length;
    }

    public byte getCharAt(int column, int row) {
        if (row >= 0 && row < this.chars.length && column >= 0 && column < this.chars[0].length) {
            return this.chars[row][column];
        }
        return 0;
    }

    public static int getCharX0(LcdParams params, int column) {
        return column * (LcdDisplay.getCharWidth(params) + params.charGap) + params.charGap + params.x0;
    }

    public static int getCharY0(LcdParams params, int row) {
        return row * (LcdDisplay.getCharHeight(params) + params.charGap) + params.charGap + params.y0;
    }

    public static int getCharWidth(LcdParams params) {
        int w = params.font != null ? params.font.charWidth() : 5;
        return params.pixelWidth * w + params.pixelGap * (w - 1);
    }

    public static int getCharHeight(LcdParams params) {
        int h = params.font != null ? params.font.charHeight() : 8;
        return params.pixelHeight * h + params.pixelGap * (h - 1);
    }

    public static void drawChar(LcdParams params, int x0, int y0, int column, int row, byte code, Graphics g) {
        if (params.font == null) {
            return;
        }
        x0 += LcdDisplay.getCharX0(params, column);
        y0 += LcdDisplay.getCharY0(params, row);
        for (int y = 0; y < params.font.charHeight(); ++y) {
            for (int x = 0; x < params.font.charWidth(); ++x) {
                boolean on = params.font.getCharPoint(code, x, y);
                if (on) {
                    if (params.pixelOnColor == null) continue;
                    g.setColor(params.pixelOnColor);
                } else {
                    if (params.pixelOffColor == null || params.pixelOffColor == params.backgroundColor) continue;
                    g.setColor(params.pixelOffColor);
                }
                g.fillRect(x0 + (params.pixelWidth + params.pixelGap) * x, y0 + (params.pixelHeight + params.pixelGap) * y, params.pixelWidth, params.pixelHeight);
            }
        }
    }

    public static void paintChars(LcdParams params, byte[][] chars, int x0, int y0, int canvasWidth, int canvasHeight, Graphics g) {
        if (params.backgroundColor != null) {
            g.setColor(params.backgroundColor);
            g.fillRect(x0, y0, canvasWidth, canvasHeight);
        }
        for (int row = 0; row < chars.length; ++row) {
            for (int col = 0; col < chars[row].length; ++col) {
                LcdDisplay.drawChar(params, x0, y0, col, row, chars[row][col], g);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        LcdDisplay.paintChars(this.params, this.chars, 0, 0, this.getWidth(), this.getHeight(), g);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("LCD display 8x2 demo");
                LcdDisplay lcd = new LcdDisplay(new Cyrillic5x8(), 8, 2);
                lcd.setText(0, "Hello#2! #fd");
                lcd.setText(1, "\u041f\u0440\u0438\u0432\u0435\u0442_#ED");
                frame.setDefaultCloseOperation(3);
                frame.add(lcd);
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public static class LcdParams {
        public static final Color DEF_BG = new Color(173, 255, 47);
        public static final Color DEF_ON = new Color(0, 0, 0);
        public static final Color DEF_OFF = new Color(166, 248, 40);
        public int x0 = 0;
        public int y0 = 0;
        public int pixelWidth = 4;
        public int pixelHeight = 5;
        public int pixelGap = 1;
        public int charGap = 4;
        public Color backgroundColor = DEF_BG;
        public Color pixelOnColor = DEF_ON;
        public Color pixelOffColor = DEF_OFF;
        public LcdFont font;
        public int columnsCount;
        public int rowsCount;
    }
}

