/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.variables.VariableRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class VariableSelectDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static VariableSelectDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JLabel lblType;
    JLabel lblWrite;
    JLabel lblComment;
    JComboBox<VariableRef> cmbxVar;

    public static VariableRef showDialog(FbdVariable block, int type, Component owner, int screenX, int screenY) {
        if (dialog == null) {
            dialog = new VariableSelectDialog(MainFrame.instance);
        }
        VariableSelectDialog.dialog.cmbxVar.requestFocusInWindow();
        VariableSelectDialog.dialog.okPressed = false;
        dialog.setControls(block, type);
        dialog.pack();
        Main.setDlgLocation(dialog, owner, screenX, screenY);
        dialog.setVisible(true);
        if (VariableSelectDialog.dialog.okPressed) {
            VariableRef var = (VariableRef)VariableSelectDialog.dialog.cmbxVar.getSelectedItem();
            if (block != null) {
                block.setVariable(var);
            }
            return var;
        }
        return null;
    }

    public VariableSelectDialog(JFrame parent) {
        super(parent, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableRef var = (VariableRef)dialog.cmbxVar.getSelectedItem();
                VariableSelectDialog.this.btnOk.setEnabled(var != null);
                String comment = var != null ? var.varDef.getCommentHtml() : "";
                VariableSelectDialog.this.lblComment.setVisible(!Utils.strEmpty(comment));
                VariableSelectDialog.this.lblComment.setText("<html>" + comment + "</html>");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VariableSelectDialog.this.pack();
                    }
                });
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", "[]"));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.lblType = new JLabel("type");
        this.lblWrite = new JLabel("<html><strong>\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430\u044f \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438</strong></html>");
        this.lblComment = new JLabel("comment");
        this.cmbxVar = new JComboBox();
        this.cmbxVar.setMaximumRowCount(20);
        this.cmbxVar.addActionListener(update);
        pnlContents.add((Component)this.lblType, "gaptop 4px, alignx center, wrap");
        pnlContents.add((Component)this.lblWrite, "gaptop 4px, alignx center, wrap, hidemode 3");
        pnlContents.add(this.cmbxVar, "gaptop 4px, alignx center, wrap");
        pnlContents.add((Component)this.lblComment, "gaptop 4px, width 200px!, wrap");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(FbdVariable block, int type) {
        ArrayList<VariableRef> vars = MainFrame.instance.getVarsEditor().getAllVariables(true, type);
        Vector<VariableRef> vector = new Vector<VariableRef>();
        VariableRef var = null;
        boolean readOnly = true;
        if (block != null) {
            var = block.getVariable();
            readOnly = !block.isWritten();
            type = var.type();
        }
        for (VariableRef v : vars) {
            if (v == null || v.type() != type || !readOnly && !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cmbxVar.setModel(new DefaultComboBoxModel(vector));
        this.cmbxVar.setSelectedItem(var);
        if (type == 1) {
            this.lblType.setText("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f (B)");
        } else if (type == 2) {
            this.lblType.setText("\u0426\u0435\u043b\u0430\u044f (I)");
        } else {
            this.lblType.setText("\u0412\u0435\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f (F)");
        }
        this.lblWrite.setVisible(!readOnly);
        this.pack();
    }
}

