/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Color;
import java.awt.Graphics2D;

public class InputPin
extends AFbdPin {
    private OutputPin source;
    public final boolean isArray;
    private int sourceId = -1;

    public InputPin(AFbdItem owner, int type, String name, int row, boolean array) {
        super(owner, type, name, row);
        this.isArray = array;
    }

    public InputPin(AFbdItem owner, int type, String name, int row) {
        this(owner, type, name, row, false);
    }

    protected void initSourceId(int id) {
        assert (this.sourceId == -1);
        this.sourceId = id;
    }

    int getSourceId() {
        return FbdPage.getOutPinId(this.getSource());
    }

    void resolveLink(boolean strict) throws FbdLoadError {
        assert (this.source == null);
        if (this.sourceId >= 0) {
            OutputPin src = FbdPage.locateOutPinById(this.sourceId);
            if (src == null && strict) {
                throw new FbdLoadError("Cannot find link source: " + this.sourceId);
            }
            this.connectSource(src);
            this.sourceId = -1;
        }
    }

    public boolean canConnectSource(OutputPin source) {
        return source == null || source == this.source && this.owner.page.editor.oldTargetPin == this || this.source == null && source.type == this.type;
    }

    public boolean connectSource(OutputPin source) {
        if (source != this.source && this.canConnectSource(source)) {
            if (this.source != null) {
                this.source.unRegisterTarget(this);
            }
            this.source = source;
            if (this.source != null) {
                this.source.registerTarget(this);
            }
            this.owner.markModified();
            return true;
        }
        return false;
    }

    public OutputPin getSource() {
        return this.source;
    }

    public boolean isVariable() {
        return this.owner instanceof FbdVariable;
    }

    protected static void paintPinOutline(Graphics2D g2d, int type, int x, int y, int w, int h) {
        if (type == 3) {
            g2d.drawLine(x + 2, y - 1, x + w / 2, y - 1);
            g2d.drawLine(x + 2, y + h, x + w / 2, y + h);
            g2d.drawArc(x, y - 1, w, h + 1, -90, 180);
        } else if (type == 1) {
            InputPin.px[0] = x + 2;
            InputPin.py[0] = y - 1;
            InputPin.px[1] = x + w + 1;
            InputPin.py[1] = y + h / 2;
            InputPin.px[2] = x + 2;
            InputPin.py[2] = y + h;
            g2d.drawPolyline(px, py, 3);
        } else {
            g2d.drawLine(x + 2, y, x + w, y);
            g2d.drawLine(x + w, y, x + w, y + h - 1);
            g2d.drawLine(x + 2, y + h - 1, x + w, y + h - 1);
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        boolean reconnect;
        this.updateBounds();
        boolean bl = reconnect = this.owner.page != null && (this.owner.page.editor.oldTargetPin == this || this.owner.page.editor.connectingInputPin == this);
        if (this.source == null || reconnect) {
            boolean hovered;
            boolean bl2 = hovered = this.owner.page != null && this.owner.page.editor.hoveredPin == this;
            g2d.setColor(reconnect ? Color.RED : (hovered ? Color.ORANGE : Color.WHITE));
            InputPin.paintPin(g2d, this.type, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            if (!reconnect && this.source == null) {
                g2d.setColor(InputPin.typeColor(this.type));
                g2d.setStroke(AFbdBlock.SHAPE_STROKE);
                InputPin.paintPinOutline(g2d, this.type, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
        }
        if (!Utils.strEmpty(this.name)) {
            g2d.setColor(Color.BLACK);
            g2d.setFont(NAME_FONT);
            g2d.drawString(this.name, this.bounds.x + this.bounds.width + 3, this.bounds.y + this.bounds.height - 1);
        }
    }

    @Override
    protected void updateBounds() {
        this.linkPoint.x = this.owner.pxBounds.x - 2;
        this.linkPoint.y = this.getCellY() * 27 + 13;
        this.bounds.x = this.linkPoint.x;
        this.bounds.y = this.linkPoint.y - 5;
        this.bounds.width = 11;
        this.bounds.height = 11;
    }
}

