/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.compiler.Variable;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.FbdConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class AFbdPin
implements FbdConstants {
    static final Color HOVER_COLOR = Color.ORANGE;
    static final Color F_COLOR = new Color(26112);
    static final Color I_COLOR = new Color(139);
    static final Color B_COLOR = new Color(0x8B0000);
    static final Font NAME_FONT = new Font("Sans", 0, 12);
    public final AFbdItem owner;
    public final int type;
    public final String name;
    public final int row;
    private Variable compiledVar;
    protected Point linkPoint = new Point();
    protected Rectangle bounds = new Rectangle();
    protected static int[] px = new int[3];
    protected static int[] py = new int[3];

    public AFbdPin(AFbdItem owner, int type, String name, int row) {
        this.owner = owner;
        this.type = type;
        this.name = name;
        this.row = row;
    }

    public int getCellY() {
        return this.owner.cellBounds.y + this.row + this.owner.padTop;
    }

    public Variable getCompiledVar() {
        return this.compiledVar;
    }

    public void setCompiledVar(Variable var) {
        this.compiledVar = var;
    }

    public abstract void paint(Graphics2D var1);

    protected abstract void updateBounds();

    protected static void paintPin(Graphics2D g2d, int type, int x, int y, int w, int h) {
        if (type == 3) {
            g2d.fillRect(x, y, (int)((double)w / 2.0 + 0.5), h);
            g2d.fillArc(x, y, w, h, -90, 180);
        } else if (type == 1) {
            AFbdPin.px[0] = x;
            AFbdPin.py[0] = y - 1;
            AFbdPin.px[1] = x + w + 1;
            AFbdPin.py[1] = y + h / 2;
            AFbdPin.px[2] = x;
            AFbdPin.py[2] = y + h + 1;
            g2d.fillPolygon(px, py, 3);
        } else {
            g2d.fillRect(x, y + 1, w, h - 2);
        }
    }

    public final Point getLinkPoint() {
        this.updateBounds();
        return this.linkPoint;
    }

    public static Color typeColor(int type) {
        if (type == 1) {
            return B_COLOR;
        }
        if (type == 2) {
            return I_COLOR;
        }
        return F_COLOR;
    }
}

