/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.archive;

import certa.vics.ide.archive.ArchiveItemView;
import certa.vics.lcd.LcdDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class LcdTextCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    final LcdDisplay.LcdParams LCD = new LcdDisplay.LcdParams();
    int lcdWidth;
    int lcdHeight;
    byte[][] lcdChars;

    LcdTextCellRenderer() {
    }

    public void initLcd(LcdFont font, int columns, int rows) {
        this.LCD.font = font;
        this.LCD.rowsCount = rows;
        this.LCD.columnsCount = columns;
        this.LCD.pixelHeight = 2;
        this.LCD.pixelWidth = 2;
        this.LCD.pixelGap = 0;
        this.LCD.charGap = 2;
        this.LCD.pixelOffColor = null;
        this.LCD.backgroundColor = null;
        this.lcdWidth = LcdDisplay.getCharX0(this.LCD, this.LCD.columnsCount);
        this.lcdHeight = LcdDisplay.getCharY0(this.LCD, this.LCD.rowsCount);
        this.lcdChars = new byte[rows][columns];
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table == null) {
            return this;
        }
        ArchiveItemView ai = (ArchiveItemView)value;
        if (this.lcdChars != null) {
            if (ai.var != null) {
                for (int i = 0; i < Math.min(this.lcdChars.length, ai.text.size()); ++i) {
                    this.LCD.font.encodeString(ai.text.get(i), this.lcdChars[i]);
                }
            } else {
                for (byte[] r : this.lcdChars) {
                    Arrays.fill(r, (byte)0);
                }
            }
        }
        this.LCD.backgroundColor = this.getBackground();
        this.LCD.pixelOnColor = this.getForeground();
        return this;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.LCD.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x0 = Math.max((this.getWidth() - this.lcdWidth) / 2, 0);
        int y0 = Math.max((this.getHeight() - this.lcdHeight) / 2, 0);
        LcdDisplay.paintChars(this.LCD, this.lcdChars, x0, y0, this.lcdWidth, this.lcdHeight, g);
    }
}

