/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.archive;

import certa.vics.compiler.Archive;
import certa.vics.compiler.Device;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.archive.ArchiveEditor;
import certa.vics.ide.archive.ArchiveItemView;
import certa.vics.ide.archive.LcdTextCellRenderer;
import certa.vics.ide.ui.StringsEditor;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ArchiveTableView
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int COL_CODE = 0;
    public static final int COL_VAR = 1;
    public static final int COL_TEXT = 2;
    public static final int COL_COMMENT = 3;
    public static final String[] COLUMNS = new String[]{"\u041a\u043e\u0434", "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"};
    static final int[] DEF_COLUMNS_W = new int[]{50, 200, 200, 500};
    final ArchiveItemView[] list = new ArchiveItemView[50];
    final ArchiveEditor editor;
    JTable table;
    ArchiveTableModel model;
    JComboBox<VariableRef> cmbxVarlist;
    IdeTableCellRenderer commentRender = new IdeTableCellRenderer(2, 8);
    LcdTextCellRenderer lcdRenderer = new LcdTextCellRenderer();
    JPopupMenu popup;
    boolean isModified;
    private MouseListener focuser = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            ArchiveTableView.this.table.requestFocusInWindow();
        }
    };
    boolean inUpdate;
    static final String PROP_COL_WIDTH = ".colwidth";

    public ArchiveTableView(ArchiveEditor editor) {
        this.editor = editor;
        this.model = new ArchiveTableModel();
        this.table = new JTable(this.model);
        this.cmbxVarlist = new JComboBox();
        this.setupTable();
        this.loadProps();
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
        scroll.addMouseListener(this.focuser);
        this.table.getTableHeader().addMouseListener(this.focuser);
        this.popup = new JPopupMenu();
        this.popup.add(new JMenuItem(editor.actions.editText));
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    protected int getSelectedIndex() {
        int sel = this.table.getSelectedRow();
        if (sel >= 0) {
            return this.table.convertRowIndexToModel(sel);
        }
        return sel;
    }

    public ArchiveItemView getSelectedItem() {
        int sel = this.getSelectedIndex();
        if (sel >= 0 && sel < this.list.length) {
            return this.list[sel];
        }
        return null;
    }

    private boolean showPopup(MouseEvent e) {
        if (e.isPopupTrigger() && e.getComponent() == this.table) {
            this.table.requestFocusInWindow();
            int r = this.table.rowAtPoint(e.getPoint());
            int c = this.table.columnAtPoint(e.getPoint());
            if (r >= 0 && c >= 0) {
                this.table.changeSelection(r, c, false, false);
            } else {
                this.table.clearSelection();
            }
            if (this.table.getSelectedRow() >= 0) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            return true;
        }
        return false;
    }

    private void setupTable() {
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setCellRenderer(new IdeTableCellRenderer(4, 8));
        cm.getColumn(1).setCellEditor(new DefaultCellEditor(this.cmbxVarlist));
        cm.getColumn(2).setCellRenderer(this.lcdRenderer);
        cm.getColumn(3).setCellRenderer(this.commentRender);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn c = cm.getColumn(i);
            if (c.getCellRenderer() != null) continue;
            c.setCellRenderer(new IdeTableCellRenderer(2, 8));
        }
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArchiveTableView.this.editor.actions.update();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ArchiveTableView.this.editor.actions.editText.actionPerformed(null);
                } else {
                    ArchiveTableView.this.showPopup(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ArchiveTableView.this.showPopup(e);
            }
        });
    }

    private void loadProps() {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(Main.props.getInt("archive.colwidth" + i, DEF_COLUMNS_W[i]));
        }
    }

    public void saveProps() {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            Main.props.saveInt("archive.colwidth" + i, cm.getColumn(i).getPreferredWidth());
        }
    }

    public void updateVarList(VariablesEditor ved) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (ved == null) {
            return;
        }
        ArrayList<VariableRef> varList = ved.getAllVariables(true, 0);
        Iterator<VariableRef> it = varList.iterator();
        while (it.hasNext()) {
            if (it.next().type() == 1) continue;
            it.remove();
        }
        varList.add(0, null);
        this.cmbxVarlist.setModel(new DefaultComboBoxModel<VariableRef>(new Vector<VariableRef>(varList)));
    }

    public void load(Program prg, VariablesEditor ved) {
        Arrays.fill(this.list, null);
        if (prg != null) {
            this.lcdRenderer.initLcd(prg.device.FONT, prg.device.DISPLAY_COLS, 2);
            int size = prg.archive.size();
            Archive arc = prg.archive;
            this.inUpdate = true;
            for (int i = 0; i < this.list.length; ++i) {
                this.list[i] = i < size ? new ArchiveItemView(ved.makeRef(arc.getVar(i)), arc.getString1(i).getSource().replace('_', ' '), arc.getString2(i).getSource().replace('_', ' ')) : new ArchiveItemView(null, "", "");
            }
        }
        this.updateVarList(ved);
        this.model.fireTableDataChanged();
        this.updateTableView();
    }

    public void compile(Program prg) throws SyntaxError {
        int i;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        Archive arc = prg.archive;
        arc.clear();
        int size = 0;
        for (i = 0; i < this.list.length; ++i) {
            if (this.list[i].var == null) continue;
            size = i + 1;
        }
        for (i = 0; i < size; ++i) {
            ArchiveItemView ai = this.list[i];
            arc.addCompiled(ai.var != null ? ai.var.getCompiledVar() : null, prg.newArchiveString(ai.text.get(0).replace(' ', '_')), prg.newArchiveString(ai.text.get(1).replace(' ', '_')));
        }
    }

    protected void updateTableView() {
        int lcdHeight = this.lcdRenderer.lcdHeight;
        TableColumn col = this.table.getTableHeader().getColumnModel().getColumn(this.table.convertColumnIndexToView(3));
        int w = 100;
        for (int r = 0; r < this.list.length; ++r) {
            JLabel c = (JLabel)this.commentRender.getTableCellRendererComponent(this.table, this.model.getValueAt(r, 3), false, false, r, 3);
            Dimension ps = c.getPreferredSize();
            this.table.setRowHeight(this.table.convertRowIndexToView(r), Math.max(lcdHeight, ps.height) + 4);
            w = Math.max(w, ps.width + 30);
        }
        col.setMinWidth(w);
        col.setPreferredWidth(w);
    }

    boolean editLcdText(ArchiveItemView ai) {
        if (ai.var != null) {
            Device dev = MainFrame.instance.program.device;
            return StringsEditor.editStrings(ai.text, false, false, dev.DISPLAY_COLS, dev.FONT, ai.var.shortName(), this.editor);
        }
        return false;
    }

    void markModifiedRow(int rowIndex) {
        this.markModified();
        this.editor.updateVarRefs();
        this.model.fireTableRowsUpdated(rowIndex, rowIndex);
        this.updateTableView();
        IdeAction.updateAll();
    }

    class ArchiveTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        ArchiveTableModel() {
        }

        @Override
        public int getRowCount() {
            return ArchiveTableView.this.list.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return VariableRef.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                VariableRef v = null;
                if (aValue instanceof VariableRef) {
                    v = (VariableRef)aValue;
                }
                ArchiveItemView ai = ArchiveTableView.this.list[rowIndex];
                if (!VariableRef.sameVar(ai.var, v)) {
                    ai.var = v;
                    ArchiveTableView.this.markModifiedRow(rowIndex);
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ArchiveItemView rv = ArchiveTableView.this.list[rowIndex];
            if (rv == null) {
                return null;
            }
            if (columnIndex == 0) {
                return Integer.toString(rowIndex);
            }
            if (columnIndex == 1) {
                if (rv.var != null) {
                    return rv.var;
                }
                return null;
            }
            if (columnIndex == 3) {
                if (rv.var != null) {
                    return "<html>" + rv.var.varDef.getCommentHtml() + "</html>";
                }
                return " ";
            }
            if (columnIndex == 2) {
                return rv;
            }
            return null;
        }
    }
}

