/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.compiler.Program;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.StringsEditor;
import certa.vics.lcd.LcdDisplay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class ProgramInfoDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static ProgramInfoDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JLabel lblTarget;
    JLabel lblHint;
    LcdDisplay lcdProgId;
    JButton btnEditId;
    JPanel pnlComment;
    JTextArea txtComment;

    public static boolean showDialog() {
        if (dialog == null) {
            dialog = new ProgramInfoDialog(MainFrame.instance);
        }
        ProgramInfoDialog.dialog.btnOk.requestFocusInWindow();
        ProgramInfoDialog.dialog.okPressed = false;
        Program prog = MainFrame.instance.program;
        dialog.setControls(prog);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (ProgramInfoDialog.dialog.okPressed) {
            return dialog.updateProgram(prog);
        }
        return false;
    }

    void editText() {
        LcdDisplay lcd = this.lcdProgId;
        String res = StringsEditor.editString(lcd.getText(0), lcd.getColumnsCount(), lcd.getLcdFont(), "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", this);
        if (res != null) {
            this.lcdProgId.setText(0, res);
        }
    }

    public ProgramInfoDialog(JFrame parent) {
        super(parent, "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProgramInfoDialog.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        final ActionListener editText = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.editText();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.lblHint = new JLabel("<html>\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u043e\u043a\u043d\u0435<br>\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e.<br>\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0442\u0430\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043f\u043e\u043c\u043e\u0436\u0435\u0442 \u0432\u0430\u043c \u0432 \u0431\u0443\u0434\u0443\u0449\u0435\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443.</html>");
        this.lblHint.setOpaque(true);
        this.lblHint.setBackground(SystemColor.info);
        this.lblHint.setForeground(SystemColor.infoText);
        this.lblHint.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.txtComment = new JTextArea();
        this.txtComment.setLineWrap(false);
        this.txtComment.setFont(new JTextField().getFont());
        this.pnlComment = new JPanel(new BorderLayout());
        this.pnlComment.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"));
        JScrollPane scroll = new JScrollPane(this.txtComment);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setHorizontalScrollBarPolicy(32);
        this.pnlComment.add((Component)scroll, "Center");
        this.lcdProgId = IdeUtils.createLcd(null, null);
        this.lcdProgId.setLcdSize(8, 1);
        this.lcdProgId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                editText.actionPerformed(null);
            }
        });
        this.btnEditId = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.btnEditId.addActionListener(editText);
        this.lblTarget = new JLabel("<>");
        this.lblTarget.addMouseListener(MainFrame.instance.modelClick);
        this.lblTarget.setCursor(Cursor.getPredefinedCursor(12));
        pnlContents.add((Component)this.lblTarget, "span, gapbottom 6px, wrap");
        pnlContents.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b:"), "alignx right");
        pnlContents.add((Component)this.lcdProgId, "");
        pnlContents.add((Component)this.btnEditId, "span, wrap");
        pnlContents.add((Component)this.lblHint, "span, wrap");
        pnlContents.add((Component)this.pnlComment, "w 500px, growx, h 300px, span");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(Program prg) {
        this.lblTarget.setText("<html>\u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440: <b>" + prg.device.Name + "</b></html>");
        this.lcdProgId.setLcdFont(prg.device.FONT);
        this.lcdProgId.setText(0, prg.id);
        this.txtComment.setText(prg.comment.trim());
        this.validData();
    }

    boolean updateProgram(Program prg) {
        String id = this.lcdProgId.getText(0);
        String c = this.txtComment.getText().trim();
        boolean mod = !id.equals(prg.id) || !c.equals(prg.comment);
        prg.id = id;
        prg.comment = c;
        return mod;
    }

    boolean validData() {
        boolean error = false;
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }
}

