/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NumberTextField
extends JTextField
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    public double floatMin = -999999.0;
    public double floatMax = 999999.0;
    public int valueType;
    public JLabel errorLabel;
    public double value;
    private ActionListener listener;

    public NumberTextField(int columns, int valueType, JLabel errorLabel, ActionListener listener) {
        super(columns);
        this.valueType = valueType;
        this.errorLabel = errorLabel;
        this.listener = listener;
        this.getDocument().addDocumentListener(this);
    }

    public void setValue(double value) {
        this.setText(Utils.numToString(value));
    }

    public boolean validData() {
        this.value = Double.NaN;
        boolean error = false;
        double min = this.floatMin;
        double max = this.floatMax;
        if (this.valueType == 1) {
            min = 0.0;
            max = 1.0;
        } else if (this.valueType == 1) {
            min = -32768.0;
            max = 32767.0;
        }
        String s = this.getText();
        if (!Utils.strEmpty(s)) {
            try {
                this.value = Double.parseDouble(s.replace(',', '.'));
                if (this.valueType != 3) {
                    this.value = (int)this.value;
                }
                if (this.value < min || this.value > max) {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
        }
        if (error) {
            if (this.errorLabel != null) {
                this.errorLabel.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 " + Utils.numToString(min) + " \u0434\u043e " + Utils.numToString(max));
                this.errorLabel.setVisible(true);
            }
        } else if (this.errorLabel != null) {
            this.errorLabel.setVisible(false);
        }
        return !error;
    }

    private void checkChanges() {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        } else {
            this.validData();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkChanges();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkChanges();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkChanges();
    }
}

