/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.Version;
import certa.vics.compiler.Device;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.Program;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainActions;
import certa.vics.ide.ProgramInfoDialog;
import certa.vics.ide.archive.ArchiveEditor;
import certa.vics.ide.code.CodeEditor;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.modbus.ModbusEditor;
import certa.vics.ide.schedule.ScheduleEditor;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariablesEditor;
import certa.vics.lcd.LcdDisplay;
import certa.vics.tools.ExportSource;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import org.json.JSONObject;

public class MainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    public static final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    public static MainFrame instance;
    public final MainActions actions;
    public static final int VARS_EDITOR = 0;
    public static final int SCHEDULE_EDITOR = 1;
    public static final int ARCHIVE_EDITOR = 2;
    public static final int FBD_EDITOR = 3;
    public static final int CODE_EDITOR = 4;
    public static final int UI_EDITOR = 5;
    public static final int MODBUS_EDITOR = 6;
    int editorIndex;
    final ArrayList<IdeEditor> editors = new ArrayList();
    public Program program;
    private JSplitPane vertSplitter;
    private JSplitPane horSplitter;
    private JPanel pnlContents;
    private JPanel pnlToolBar;
    private JToolBar tbEditors;
    private JToolBar tbFile;
    private JToolBar tbProgram;
    private JMenu menuView;
    private JPanel pnlMain;
    private JPanel pnlLeft;
    private JPanel pnlBottom;
    private JPanel statusPanel;
    private JLabel lblModel;
    private JProgressBar barFlash = null;
    private JProgressBar barRam = null;
    private JProgressBar barStore = null;
    private JProgressBar barExt = null;
    private File currentFile;
    LcdDisplay lcdProgId;
    protected MouseListener modelClick = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MainFrame.this.actions.newS1.deviceFile.equals(MainFrame.this.program.device.PropsFile)) {
                MainFrame.this.actions.infoS1.actionPerformed(null);
            } else if (MainFrame.this.actions.newS100.deviceFile.equals(MainFrame.this.program.device.PropsFile)) {
                MainFrame.this.actions.infoS100.actionPerformed(null);
            } else if (MainFrame.this.actions.newS200.deviceFile.equals(MainFrame.this.program.device.PropsFile)) {
                MainFrame.this.actions.infoS200.actionPerformed(null);
            } else if (MainFrame.this.actions.newS300.deviceFile.equals(MainFrame.this.program.device.PropsFile)) {
                MainFrame.this.actions.infoS300.actionPerformed(null);
            } else if (MainFrame.this.actions.newSpider.deviceFile.equals(MainFrame.this.program.device.PropsFile)) {
                MainFrame.this.actions.infoSpider.actionPerformed(null);
            }
        }
    };
    static Color defMemBg;
    static Color defMemFg;
    private boolean modified;
    static final String KEY_PROG_COMMENT = "comment";
    private static final MouseAdapter mouseAdapter;
    private static final Cursor WAIT_CURSOR;
    private static final Cursor DEFAULT_CURSOR;
    int lastSplit = 0;
    boolean isSwitching;

    public MainFrame() {
        super("ViCS");
        instance = this;
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.pnlMain = new JPanel(new BorderLayout());
        this.pnlMain.setPreferredSize(new Dimension(700, 300));
        this.pnlLeft = new JPanel(new CardLayout());
        this.pnlBottom = new JPanel(new BorderLayout());
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new MigLayout("", "10[]30[]5", "3[fill]1"));
        this.statusPanel.setBorder(null);
        this.lblModel = this.createStatusLabel();
        this.lblModel.addMouseListener(this.modelClick);
        this.lblModel.setCursor(Cursor.getPredefinedCursor(12));
        this.barFlash = this.createMemStatus(" ROM: ");
        this.barRam = this.createMemStatus(" RAM: ");
        this.barStore = this.createMemStatus(" EEPROM: ");
        this.barExt = this.createMemStatus(" NVRAM: ");
        this.vertSplitter = new JSplitPane(0, this.pnlMain, this.pnlBottom);
        IdeUtils.setupDivider(this.vertSplitter);
        this.vertSplitter.setResizeWeight(1.0);
        this.horSplitter = new JSplitPane(1, this.pnlLeft, this.vertSplitter);
        IdeUtils.setupDivider(this.horSplitter);
        this.pnlContents = new JPanel(new BorderLayout());
        this.horSplitter.setBorder(BorderFactory.createEmptyBorder(2, 3, 1, 3));
        this.pnlContents.add((Component)this.horSplitter, "Center");
        this.add((Component)this.pnlContents, "Center");
        this.add((Component)this.statusPanel, "South");
        this.lcdProgId = IdeUtils.createLcd(Color.WHITE, Color.black);
        this.actions = new MainActions(this);
        this.initEditor(new VariablesEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.pnlBottom.add(this.getVarsEditor());
        this.initEditor(new ScheduleEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.initEditor(new ArchiveEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.initEditor(new FbdEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.initEditor(new CodeEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.initEditor(new UiEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.initEditor(new ModbusEditor(this, new JMenu("\u041f\u0440\u0430\u0432\u043a\u0430")));
        this.createToolBar();
        this.setJMenuBar(this.createMenuBar());
        this.setExtendedState(6);
        this.setMinimumSize(new Dimension(700, 400));
        this.setPreferredSize(new Dimension(900, 500));
        this.addWindowListener(this);
        this.lcdProgId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainFrame.this.actions.info.actionPerformed(null);
            }
        });
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (MainFrame.this.isSwitching) {
                    return;
                }
                String prop = e.getPropertyName();
                Object obj = e.getNewValue();
                if ("focusOwner".equals(prop) && obj instanceof Component) {
                    MainFrame.this.updateFocus((Component)obj);
                }
            }
        });
        this.closeProgram();
        this.pack();
    }

    protected void registerToolBar(JToolBar toolBar) {
        if (toolBar.getParent() != this.pnlToolBar) {
            this.pnlToolBar.add(toolBar);
            this.pnlToolBar.validate();
            this.pnlToolBar.repaint();
        }
    }

    protected void unregisterToolBar(JToolBar toolBar) {
        if (toolBar.getParent() == this.pnlToolBar) {
            this.pnlToolBar.remove(toolBar);
            this.pnlToolBar.validate();
            this.pnlToolBar.repaint();
        }
    }

    private void updateFocus(Component focusOwner) {
        for (IdeEditor ed : this.editors) {
            if (!ed.isAvailable()) continue;
            ed.updateFocus(focusOwner);
        }
        IdeAction.updateAll();
        this.repaint();
    }

    public void updateProgId() {
        if (this.program != null) {
            this.lcdProgId.setLcdFont(this.program.device.FONT);
            this.lcdProgId.setLcdSize(8, 1);
            this.lcdProgId.setText(0, this.program.id);
        }
    }

    private void updateControls() {
        boolean opened = this.program != null;
        this.horSplitter.setVisible(opened);
        this.statusPanel.setVisible(opened);
        this.tbEditors.setVisible(opened);
        this.updateProgId();
        this.tbProgram.setVisible(opened);
        this.menuView.setVisible(opened);
        for (IdeEditor ed : this.editors) {
            ed.setAvailable(opened);
        }
        this.loadSplitters();
        if (opened) {
            this.editors.get(2).setAvailable(this.program.hasArchive());
            this.editors.get(1).setAvailable(this.program.hasSchedule());
            this.editors.get(5).setAvailable(this.program.hasDisplay());
        }
    }

    protected void closeProgram() {
        this.saveSplitters();
        this.setEditor(-1);
        this.setCurrentFile(null);
        this.program = null;
        for (IdeEditor ed : this.editors) {
            ed.clear();
        }
        this.updateControls();
        IdeAction.updateAll();
    }

    public boolean isFbdMode() {
        return this.editors.get(3).isAvailable();
    }

    private JProgressBar createMemStatus(String title) {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 0));
        pnl.setBorder(null);
        pnl.add(new JLabel(title));
        defMemBg = pnl.getBackground();
        defMemFg = pnl.getForeground();
        pnl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    MainFrame.this.updateProgram(null);
                }
                catch (Exception ex) {
                    Utils.ProcessException(ex, false);
                }
            }
        });
        JProgressBar bar = new JProgressBar();
        bar.setStringPainted(true);
        bar.setString("");
        pnl.add((Component)bar, "Center");
        this.statusPanel.add(pnl);
        return bar;
    }

    private JLabel createStatusLabel() {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(1));
        this.statusPanel.add(label);
        return label;
    }

    private void updateMemBar(JProgressBar bar, int maxSize, int size) {
        if (maxSize > 0) {
            bar.getParent().setVisible(true);
            bar.setMaximum(maxSize);
            bar.setValue(size);
            bar.setString(size * 100 / maxSize + "%");
            if (size > maxSize) {
                bar.getParent().setBackground(Color.RED);
            } else {
                bar.getParent().setBackground(defMemBg);
            }
            bar.setToolTipText(maxSize + " \u0431\u0430\u0439\u0442. \u0417\u0430\u043d\u044f\u0442\u043e " + size);
        } else {
            bar.getParent().setVisible(false);
        }
    }

    private void updateMemoryStatus() {
        this.updateMemBar(this.barFlash, this.program.device.FlashSize, this.program.getFlashSize());
        this.updateMemBar(this.barRam, this.program.device.RamSize, this.program.getRamSize());
        this.updateMemBar(this.barStore, this.program.device.EepromSize, this.program.getStoreSize());
        this.updateMemBar(this.barExt, this.program.device.NvramSize, this.program.getExtSize());
    }

    private void initEditor(IdeEditor editor) {
        this.editors.add(editor);
    }

    protected JCheckBoxMenuItem newToggleMenuItem(MainActions.SetEditor a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        a.addButton(mi);
        return mi;
    }

    JMenuItem noIcon(JMenuItem mi) {
        mi.setIcon(null);
        return mi;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("\u0424\u0430\u0439\u043b");
        JMenu submenu = new JMenu("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        submenu.setIcon(Utils.loadImageIcon("new.png"));
        submenu.add(new JMenuItem(this.actions.newS1));
        submenu.add(new JMenuItem(this.actions.newS100));
        submenu.add(new JMenuItem(this.actions.newS200));
        submenu.add(new JMenuItem(this.actions.newS300));
        submenu.add(new JMenuItem(this.actions.newSpider));
        menu.add(submenu);
        menu.add(new JMenuItem(this.actions.load));
        menu.add(new JMenuItem(this.actions.save));
        menu.add(new JMenuItem(this.actions.saveAs));
        submenu = new JMenu("\u042d\u043a\u0441\u043f\u043e\u0440\u0442");
        submenu.add(new JMenuItem(this.actions.exportModbus));
        submenu.add(new JMenuItem(this.actions.exportUi));
        submenu.addSeparator();
        submenu.add(new JMenuItem(this.actions.exportVics));
        menu.add(submenu);
        menu.addSeparator();
        menu.add(new JMenuItem(this.actions.info));
        menu.addSeparator();
        menu.add(new JMenuItem(this.actions.flash));
        menu.addSeparator();
        menu.add(new JMenuItem(this.actions.exit));
        menuBar.add(menu);
        this.menuView = new JMenu("\u0412\u0438\u0434");
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setFbd));
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setCode));
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setUi));
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setModbus));
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setSchedule));
        this.menuView.add(this.newToggleMenuItem((MainActions.SetEditor)this.actions.setArchive));
        this.menuView.addSeparator();
        JMenu subMenu = new JMenu("\u041c\u0430\u0441\u0448\u0442\u0430\u0431");
        subMenu.add(new JMenuItem(this.actions.zoomIn));
        subMenu.add(new JMenuItem(this.actions.zoomOut));
        subMenu.add(new JMenuItem(this.actions.zoomReset));
        this.menuView.add(subMenu);
        menuBar.add(this.menuView);
        for (IdeEditor e : this.editors) {
            menuBar.add(e.menu);
        }
        menu = new JMenu("\u0421\u043f\u0440\u0430\u0432\u043a\u0430");
        menu.add(this.noIcon(new JMenuItem(this.actions.flashHelp)));
        menu.add(this.noIcon(new JMenuItem(this.actions.varsHelp)));
        menu.add(this.noIcon(new JMenuItem(this.actions.infoS1)));
        menu.add(this.noIcon(new JMenuItem(this.actions.infoS100)));
        menu.add(this.noIcon(new JMenuItem(this.actions.infoS200)));
        menu.add(this.noIcon(new JMenuItem(this.actions.infoS300)));
        menu.add(this.noIcon(new JMenuItem(this.actions.infoSpider)));
        submenu = new JMenu("\u041f\u0440\u0438\u043c\u0435\u0440\u044b");
        submenu.setIcon(Utils.loadImageIcon("samples.png"));
        submenu.add(new JMenuItem(this.actions.sample6));
        submenu.add(new JMenuItem(this.actions.sample5));
        submenu.add(new JMenuItem(this.actions.sample1));
        submenu.add(new JMenuItem(this.actions.sample2));
        submenu.add(new JMenuItem(this.actions.sample3));
        submenu.add(new JMenuItem(this.actions.sample4));
        menu.add(submenu);
        menu.addSeparator();
        menu.add(new JMenuItem(this.actions.about));
        menuBar.add(menu);
        return menuBar;
    }

    protected JToggleButton newToggleButton(MainActions.SetEditor a) {
        JToggleButton b = new JToggleButton(a);
        if (a != null && (a.getValue("SmallIcon") != null || a.getValue("SwingLargeIconKey") != null)) {
            b.setHideActionText(true);
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setFocusable(false);
        a.addButton(b);
        return b;
    }

    public void createToolBar() {
        this.pnlToolBar = new JPanel(new FlowLayout(0, 0, 0));
        this.add((Component)this.pnlToolBar, "First");
        this.tbFile = IdeUtils.newToolBar();
        JPopupMenu popupNew = new JPopupMenu();
        popupNew.add(this.actions.newS1);
        popupNew.add(this.actions.newS100);
        popupNew.add(this.actions.newS200);
        popupNew.add(this.actions.newS300);
        popupNew.add(this.actions.newSpider);
        this.tbFile.add(IdeUtils.newPopupButton(popupNew, "new.png", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443"));
        this.tbFile.add(this.actions.load).setFocusable(false);
        this.tbFile.add(this.actions.save).setFocusable(false);
        this.pnlToolBar.add(this.tbFile);
        this.tbEditors = IdeUtils.newToolBar();
        this.tbEditors.addSeparator();
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setFbd));
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setCode));
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setUi));
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setModbus));
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setSchedule));
        this.tbEditors.add(this.newToggleButton((MainActions.SetEditor)this.actions.setArchive));
        this.tbEditors.addSeparator();
        this.pnlToolBar.add(this.tbEditors);
        this.tbProgram = IdeUtils.newToolBar();
        this.tbProgram.add(this.lcdProgId);
        this.tbProgram.add(this.actions.info).setFocusable(false);
        this.tbProgram.addSeparator();
        this.tbProgram.add(this.actions.flash).setFocusable(false);
        this.tbProgram.addSeparator();
        this.pnlToolBar.add(this.tbProgram);
        this.pnlToolBar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (IdeEditor ed : MainFrame.this.editors) {
                    ed.updateToolbar();
                }
            }
        });
    }

    private void loadSplitters() {
        this.vertSplitter.setDividerLocation(this.getContentPane().getHeight() - Math.max(Main.props.getInt("main.vsplit", 300), 30));
        this.lastSplit = Math.max(Main.props.getInt("main.hsplit", 300), 40);
        this.horSplitter.setDividerLocation(this.lastSplit);
    }

    private void saveSplitters() {
        if (this.program == null) {
            return;
        }
        Main.props.saveInt("main.vsplit", this.getContentPane().getHeight() - this.vertSplitter.getDividerLocation());
        if (this.pnlLeft.isVisible()) {
            this.lastSplit = this.horSplitter.getDividerLocation();
        }
        Main.props.saveInt("main.hsplit", this.lastSplit);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.loadSplitters();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.canClose()) {
            this.setDefaultCloseOperation(3);
            for (IdeEditor ed : this.editors) {
                ed.saveProps();
            }
            this.saveSplitters();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void markModified() {
        this.modified = true;
        IdeAction.updateAll();
    }

    protected boolean isModified() {
        return this.modified;
    }

    public boolean canClose() {
        if (this.isModified()) {
            int n = JOptionPane.showConfirmDialog(this, "\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043d\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430.\n\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c?", "", 1);
            if (n == 0) {
                this.actions.save.actionPerformed(null);
                return !this.isModified();
            }
            return n == 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVics(File file) {
        this.startWaitCursor();
        try {
            this.closeProgram();
            Program prg = new Program();
            try {
                prg.loadFromFile(file.getAbsolutePath(), false);
                for (IdeEditor ed : this.editors) {
                    ed.clear();
                }
                this.program = prg;
                this.updateControls();
                this.setCurrentFile(file);
                this.updateEditors();
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                Throwable cause = e.getCause();
                if (cause instanceof Program.OldEditorError) {
                    JOptionPane.showMessageDialog(this, "\u0424\u0430\u0439\u043b " + file.getName() + " \u0441\u043e\u0437\u0434\u0430\u043d \u0432 \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 ViCS.\n\u0421\u043a\u0430\u0447\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0439 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441 \u0441\u0430\u0439\u0442\u0430 certa.com.ua", "\u041e\u0448\u0438\u0431\u043a\u0430!", 0);
                } else {
                    JOptionPane.showMessageDialog(this, file.getName() + "\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
                }
                this.closeProgram();
                this.stopWaitCursor();
                return;
            }
        }
        finally {
            this.stopWaitCursor();
        }
        if (this.program.fileVersion < 7) {
            if (this.program.fileVersion == 3) {
                return;
            }
            JOptionPane.showMessageDialog(this, "\u0424\u0430\u0439\u043b '" + file.getName() + "'\n\u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d \u0432 \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 ViCS.\n\n\u0415\u0441\u043b\u0438 \u0432\u044b \u0432\u043d\u0435\u0441\u0435\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u044d\u0442\u043e\u0442 \u0444\u0430\u0439\u043b, \u0442\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0441\u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0435\u0433\u043e \n\u0432 \u0441\u0442\u0430\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0438 \u0437\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0441\u043e \u0441\u0442\u0430\u0440\u043e\u0439 \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u043e\u0439. \n\n\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c \u0441\u043a\u0430\u0447\u0430\u0442\u044c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ViCS \u0432\u0435\u0440\u0441\u0438\u0438 " + this.getEditorVersionForFile(this.program.fileVersion) + " \u0441 \u0441\u0430\u0439\u0442\u0430 certa.com.ua \n \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0435\u0433\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430.", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435!", 1);
        }
    }

    public String getEditorVersionForFile(int fileVesion) {
        switch (fileVesion) {
            case 1: {
                return "1.0";
            }
            case 2: {
                return "1.1";
            }
            case 3: {
                return "1.2";
            }
            case 4: {
                return "1.3";
            }
            case 5: {
                return "1.5";
            }
            case 6: {
                return "1.5";
            }
        }
        return "?";
    }

    public void updateProgram(JSONObject json) throws Exception {
        this.program.clear(true);
        for (IdeEditor ed : this.editors) {
            if (!ed.isAvailable()) continue;
            ed.updateProgram(json);
        }
        this.program.resolveLinks();
        this.updateMemoryStatus();
        this.lblModel.setText(this.program.device.Name);
    }

    private File saveOld(File file) {
        try {
            File dest;
            file = file.getAbsoluteFile();
            if (file.exists() && file.isFile() && ((dest = new File(file.getParentFile().getAbsolutePath() + File.separatorChar + ".vics-backup")).exists() && dest.isDirectory() || dest.mkdir())) {
                String name = file.getName();
                String ext = "";
                int i = name.lastIndexOf(46);
                if (i >= 0 && i < name.length() - 1) {
                    ext = name.substring(i);
                    name = name.substring(0, i);
                }
                Calendar now = Calendar.getInstance();
                name = name + "." + now.get(1) + "-" + String.format("%02d", now.get(2) + 1) + "-" + String.format("%02d", now.get(5)) + "_" + String.format("%02d", now.get(11)) + "-" + String.format("%02d", now.get(12)) + "-" + String.format("%02d", now.get(13)) + ext;
                dest = new File(dest.getAbsolutePath() + File.separatorChar + name);
                Files.move(file.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                return dest;
            }
            return null;
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            return null;
        }
    }

    public void startWaitCursor() {
        this.getGlassPane().setCursor(WAIT_CURSOR);
        this.getGlassPane().addMouseListener(mouseAdapter);
        this.getGlassPane().setVisible(true);
    }

    public void stopWaitCursor() {
        this.getGlassPane().setCursor(DEFAULT_CURSOR);
        this.getGlassPane().removeMouseListener(mouseAdapter);
        this.getGlassPane().setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVics(File file, boolean isExport) {
        this.startWaitCursor();
        try {
            File copy = this.saveOld(file);
            try {
                if (!isExport) {
                    this.program.fileVersion = 7;
                }
                boolean fbdFormat = this.isFbdMode() && !isExport;
                JSONObject json = null;
                if (fbdFormat) {
                    json = new JSONObject();
                }
                this.updateProgram(json);
                try {
                    this.program.makeBinaryData();
                }
                catch (Throwable e) {
                    Utils.ProcessException(e, false);
                }
                if (json != null) {
                    json.put(KEY_PROG_COMMENT, this.program.comment);
                    this.program.extraData = json.toString(2);
                } else {
                    this.program.extraData = "";
                }
                PrintWriter pw = null;
                ZipOutputStream zip = null;
                if (fbdFormat) {
                    zip = new ZipOutputStream(new FileOutputStream(file));
                    zip.putNextEntry(new ZipEntry("program"));
                    pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)zip, Charset.forName("UTF-8"))), false);
                } else {
                    pw = new PrintWriter(file, "UTF-8");
                }
                try {
                    pw.println("# ViCS version: " + Version.version);
                    ExportSource.printSource(this.program, pw, this.isFbdMode() && !isExport);
                    if (!isExport) {
                        this.setCurrentFile(file);
                    }
                    this.updateMemoryStatus();
                }
                finally {
                    pw.close();
                    if (zip != null) {
                        zip.close();
                    }
                }
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getSimpleName(), 0);
                try {
                    if (copy != null) {
                        Files.move(copy.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                }
                catch (IOException e1) {
                    Utils.ProcessException(e, false);
                }
            }
        }
        finally {
            this.stopWaitCursor();
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File f) {
        this.currentFile = f;
        for (IdeEditor ed : this.editors) {
            if (!ed.isAvailable()) continue;
            ed.markSavedToDisk();
        }
        this.modified = false;
        IdeAction.updateAll();
        this.updateTitle();
    }

    public void updateTitle() {
        String file = this.currentFile != null ? this.currentFile.getAbsolutePath() : (this.program != null ? "\u041d\u043e\u0432\u0430\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430" : "ViCS");
        this.setTitle(file + (this.isModified() ? " *" : ""));
    }

    public void createNewProgram(String deviceFile) {
        this.closeProgram();
        try {
            this.program = new Program(new Device(deviceFile));
        }
        catch (ErrorInFile | IOException e) {
            Utils.ProcessException(e, true);
        }
        if (!ProgramInfoDialog.showDialog()) {
            this.closeProgram();
            return;
        }
        this.updateProgId();
        this.updateControls();
        this.editors.get(4).setAvailable(false);
        this.setEditor(3);
        for (IdeEditor ed : this.editors) {
            if (!ed.isAvailable()) continue;
            ed.initNewProgram();
        }
        this.setCurrentFile(null);
        try {
            this.updateProgram(null);
        }
        catch (Exception e) {
            Utils.ProcessException(e, false);
        }
    }

    private void updateEditors() throws Exception {
        JSONObject json = null;
        VariablesEditor ved = this.getVarsEditor();
        if (!Utils.strEmpty(this.program.extraData) && this.program.extraData.contains("{")) {
            json = new JSONObject(this.program.extraData);
            this.editors.get(4).setAvailable(false);
            this.setEditor(3);
            this.program.comment = json.optString(KEY_PROG_COMMENT);
            ved.loadProgram(json, this.program.fileVersion);
            ved.updateProgram(json);
        } else {
            this.editors.get(3).setAvailable(false);
            this.setEditor(4);
            ved.loadProgram(null, this.program.fileVersion);
        }
        this.program.resolveLinks();
        for (IdeEditor ed : this.editors) {
            if (ed == ved || !ed.isAvailable()) continue;
            ed.loadProgram(json, this.program.fileVersion);
        }
        this.updateProgram(null);
        this.modified = false;
        IdeAction.updateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSample(String fileName) {
        this.startWaitCursor();
        try {
            InputStream in;
            Program prg;
            block8: {
                this.closeProgram();
                prg = new Program();
                in = Utils.getResourceStream("samples/" + fileName);
                if (in != null) break block8;
                return;
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                prg.load(reader, false, fileName);
                prg.fileVersion = 7;
                for (IdeEditor ed : this.editors) {
                    ed.clear();
                }
                this.program = prg;
                this.updateControls();
                this.setCurrentFile(null);
                this.updateEditors();
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this, fileName + "\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
                this.closeProgram();
                this.stopWaitCursor();
                return;
            }
        }
        finally {
            this.stopWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditor(int editorIndex) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean varsFocused = this.getVarsEditor().isFocused();
        this.isSwitching = true;
        this.pnlBottom.setVisible(false);
        try {
            if (editorIndex < 0) {
                this.pnlMain.removeAll();
                this.pnlLeft.removeAll();
            } else {
                IdeEditor ed = this.editors.get(editorIndex);
                if (ed.isAvailable()) {
                    if (this.pnlLeft.isVisible()) {
                        this.lastSplit = this.horSplitter.getDividerLocation();
                    }
                    this.pnlMain.removeAll();
                    this.pnlLeft.removeAll();
                    this.pnlMain.add((Component)ed, "Center");
                    for (IdeEditor e : this.editors) {
                        e.setActive(e == ed, !varsFocused);
                    }
                    JComponent lp = ed.getLeftPane();
                    this.pnlLeft.setVisible(lp != null);
                    if (lp != null) {
                        this.pnlLeft.add(lp);
                        this.horSplitter.setDividerLocation(Math.max(30, this.lastSplit));
                        this.horSplitter.setDividerSize(this.vertSplitter.getDividerSize());
                    } else {
                        this.horSplitter.setDividerSize(0);
                    }
                }
            }
            this.editorIndex = editorIndex;
        }
        finally {
            this.pnlBottom.setVisible(true);
            if (varsFocused) {
                this.getVarsEditor().titleClicked();
            }
            this.isSwitching = false;
            this.updateFocus(focusManager.getFocusOwner());
        }
    }

    public int getActiveEditorIndex() {
        return this.editorIndex;
    }

    public IdeEditor getActiveEditor() {
        if (this.editorIndex >= 0) {
            return this.editors.get(this.editorIndex);
        }
        return null;
    }

    public void repaintActiveEditor() {
        IdeEditor ed = this.getActiveEditor();
        if (ed != null) {
            ed.repaint();
        }
    }

    public VariablesEditor getVarsEditor() {
        return (VariablesEditor)this.editors.get(0);
    }

    public ModbusEditor getModbusEditor() {
        return (ModbusEditor)this.editors.get(6);
    }

    public ScheduleEditor getScheduleEditor() {
        return (ScheduleEditor)this.editors.get(1);
    }

    public ArchiveEditor getArchiveEditor() {
        return (ArchiveEditor)this.editors.get(2);
    }

    public UiEditor getUiEditor() {
        return (UiEditor)this.editors.get(5);
    }

    public CodeEditor getCodeEditor() {
        return (CodeEditor)this.editors.get(4);
    }

    public FbdEditor getFbdEditor() {
        return (FbdEditor)this.editors.get(3);
    }

    public void notifyVarsChanged() {
        for (IdeEditor e : this.editors) {
            if (!e.isAvailable()) continue;
            e.updateVarList();
        }
    }

    static {
        mouseAdapter = new MouseAdapter(){};
        WAIT_CURSOR = Cursor.getPredefinedCursor(3);
        DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    }
}

