/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.json.JSONObject;

public abstract class IdeEditor
extends IdeUtils.BorderedPanel {
    private static final long serialVersionUID = 1L;
    public final ActionsBundle actions;
    public final JMenu menu;
    public final JToolBar toolBar;
    protected boolean active;
    protected boolean available = true;
    private boolean modified;

    public IdeEditor(JMenu menu, String title) {
        super(new JPanel(new BorderLayout()), title);
        this.setOpaque(false);
        this.menu = menu;
        this.toolBar = IdeUtils.newToolBar();
        this.actions = this.createActions();
        this.toolBar.addMouseListener(this.focuser);
    }

    @Override
    protected void focusChanged() {
        this.actions.update();
    }

    public void setActive(boolean active, boolean focus) {
        this.active = active;
        this.updateControls();
        if (active && focus) {
            this.initFocus();
        }
    }

    public void initFocus() {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setAvailable(boolean avail) {
        this.available = avail;
        this.updateControls();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void updateControls() {
        this.menu.setVisible(false);
        this.actions.update();
        this.updateToolbar();
        if (this.toolBar.getParent() == null) {
            this.showToolBar();
        }
    }

    private void showToolBar() {
        this.contents.add((Component)this.toolBar, "First");
        this.contents.validate();
        this.contents.repaint();
    }

    private void hideToolBar() {
        this.contents.remove(this.toolBar);
        this.contents.validate();
        this.contents.repaint();
    }

    public void updateToolbar() {
        if (this.available && this.isVisible() && this.active) {
            this.hideToolBar();
            MainFrame.instance.registerToolBar(this.toolBar);
            int y = this.toolBar.getLocation().y;
            if (y > 15) {
                if (MainFrame.instance != null) {
                    MainFrame.instance.unregisterToolBar(this.toolBar);
                }
                this.showToolBar();
            }
        } else if (MainFrame.instance != null) {
            MainFrame.instance.unregisterToolBar(this.toolBar);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void markModified() {
        this.modified = true;
        if (MainFrame.instance != null) {
            MainFrame.instance.markModified();
        }
    }

    public void markSavedToDisk() {
        this.modified = false;
    }

    public abstract void initNewProgram();

    public abstract void loadProgram(JSONObject var1, int var2) throws FbdLoadError;

    public abstract void updateProgram(JSONObject var1) throws Exception;

    public abstract void clear();

    protected abstract ActionsBundle createActions();

    public abstract void saveProps();

    public abstract void updateVarList();

    public int getZoom() {
        return 100;
    }

    public void setZoom(int zoom) {
    }

    public JComponent getLeftPane() {
        return null;
    }
}

