/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.ide.CommSettingsPanel;
import certa.vics.ide.FlashThread;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.tools.ExportSource;
import certa.vics.tools.Flash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class FlashDialog
extends IdeUtils.IdeDialog
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private static FlashDialog dialog;
    private Program program;
    CommSettingsPanel pnlComm;
    JButton btnFlash;
    JPanel pnlProgress;
    JProgressBar progressBar;
    JPanel pnlError;
    JTextPane lblFlashError;
    ActionListener close = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FlashDialog.this.pnlProgress.isVisible()) {
                FlashDialog.this.saveParams();
                FlashDialog.this.setVisible(false);
            }
        }
    };
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FlashDialog.this.validData();
            FlashDialog.this.pack();
        }
    };
    ActionListener flash = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlashDialog.this.validData()) {
                FlashDialog.this.setErrorMessage(null);
                FlashDialog.this.pnlComm.setEnabled(false);
                FlashDialog.this.pnlProgress.setVisible(true);
                FlashDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                FlashDialog.this.btnFlash.setEnabled(false);
                FlashDialog.this.pack();
                Flash flash = new Flash(FlashDialog.this.program);
                try {
                    FlashThread t = new FlashThread(dialog, flash);
                    t.execute();
                }
                catch (Throwable ex) {
                    Utils.ProcessException(ex, false);
                    FlashDialog.this.flashDone(FlashDialog.errorMessage(ex));
                }
            } else {
                FlashDialog.this.setErrorMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            }
        }
    };

    public static void showDialog() {
        if (dialog == null) {
            dialog = new FlashDialog(MainFrame.instance);
        }
        try {
            MainFrame.instance.updateProgram(null);
            Program program = MainFrame.instance.program;
            program.makeBinaryData();
            try (PrintWriter pw = new PrintWriter(Utils.RootDir + File.separatorChar + "flash_data.dump", "UTF-8");){
                ExportSource.printSource(program, pw, false);
                pw.println("\n");
                program.dumpBinaryData(pw);
            }
            catch (Exception ex) {
                Utils.ProcessException(ex, false);
            }
            FlashDialog.dialog.program = program;
            dialog.initControls();
            dialog.setLocationRelativeTo(dialog.getParent());
            FlashDialog.dialog.pnlComm.updatePortsList();
            dialog.setVisible(true);
        }
        catch (Throwable ex) {
            Utils.ProcessException(ex, false);
            JOptionPane.showMessageDialog(MainFrame.instance, ex.getMessage(), "Error", 0);
        }
    }

    static String errorMessage(Throwable ex) {
        String msg = ex.getMessage();
        if (Utils.strEmpty(msg)) {
            msg = ex.getClass().getSimpleName();
        }
        return msg;
    }

    public void flashDone(String result) {
        this.pnlComm.setEnabled(true);
        this.pnlProgress.setVisible(false);
        this.setCursor(null);
        this.setErrorMessage(result);
        this.btnFlash.setEnabled(this.pnlComm.isDataValid());
        this.pack();
    }

    public FlashDialog(JFrame parent) {
        super(parent, "\u0417\u0430\u043f\u0438\u0441\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "", ""));
        this.pnlComm = new CommSettingsPanel();
        this.pnlComm.setListener(this.update);
        this.btnFlash = new JButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443");
        this.btnFlash.addActionListener(this.flash);
        JButton btnHelp = new JButton(MainFrame.instance.actions.flashHelp);
        btnHelp.setFocusable(false);
        btnHelp.setText("");
        this.pnlProgress = new JPanel(new MigLayout("", "[grow]", ""));
        this.pnlProgress.setBorder(BorderFactory.createTitledBorder("\u0417\u0430\u043f\u0438\u0441\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.pnlProgress.add((Component)this.progressBar, "newline, growx, hidemode 3");
        this.pnlError = new JPanel(new MigLayout("", "[]", "[]"));
        this.pnlError.setBorder(BorderFactory.createTitledBorder("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438!"));
        this.lblFlashError = new JTextPane();
        this.lblFlashError.setForeground(Color.RED);
        this.lblFlashError.setEditable(false);
        this.pnlError.add((Component)this.lblFlashError, "");
        pane.add((Component)this.pnlComm, "grow, span, wrap");
        pane.add((Component)btnHelp, "newline, alignx left");
        pane.add((Component)this.btnFlash, "span, alignx right");
        pane.add((Component)this.pnlProgress, "grow, span, wrap, hidemode 3");
        pane.add((Component)this.pnlError, "grow, span, hidemode 3");
        this.getRootPane().registerKeyboardAction(this.close, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    public void setErrorMessage(String msg) {
        if (!Utils.strEmpty(msg)) {
            int w = this.progressBar.getWidth();
            this.lblFlashError.setMaximumSize(new Dimension(w, 500));
            this.lblFlashError.setText(msg);
            int h = this.lblFlashError.getPreferredSize().height;
            this.lblFlashError.setSize(w, h);
            this.pnlError.setVisible(true);
        } else {
            this.pnlError.setVisible(false);
        }
        this.pack();
    }

    JLabel setupError(JLabel lbl) {
        lbl.setForeground(Color.RED);
        return lbl;
    }

    void initControls() {
        this.pnlComm.initControls();
        this.pnlProgress.setVisible(false);
        this.setErrorMessage(null);
        this.validData();
    }

    void saveParams() {
        this.pnlComm.saveParams();
    }

    boolean validData() {
        this.pack();
        boolean ok = this.pnlComm.isDataValid();
        this.btnFlash.setEnabled(ok);
        return ok;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close.actionPerformed(null);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

