/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;
import java.util.Arrays;

public class ScheduleBlock {
    public static final int ITEMS_COUNT = 12;
    public static final int FLASH_SIZE = 60;
    public static final int SCHEDULE_BLOCK_SIZE = 512;
    public static final int EXTEEPROM_SIZE = 6144;
    public int startAddressFlash;
    public final Schedule[] items = new Schedule[12];
    public final byte[] eeprom = new byte[6144];

    public Schedule alloc(int number) throws SyntaxError {
        int index = number - 1;
        if (index < 0 || index >= this.items.length) {
            throw new SyntaxError("Invalid schedule number: " + number + " (must be 1.." + this.items.length + ")");
        }
        Schedule item = this.items[index];
        if (item == null) {
            this.items[index] = item = new Schedule(number);
        }
        return item;
    }

    public void resolveLinks(Program prg) throws SyntaxError {
        for (Schedule s : this.items) {
            if (s == null) continue;
            s.resolve(prg);
        }
    }

    void clear() {
        Arrays.fill(this.items, null);
    }

    int compileData(byte[] buf, int offset) throws SyntaxError {
        int eep = 0;
        for (Schedule s : this.items) {
            if (s != null && s.var != null) {
                int vt = Program.varTypeEncode(s.var.type, s.digits);
                if (Double.isNaN(s.min)) {
                    s.min = 0.0;
                }
                if (Double.isNaN(s.max)) {
                    s.max = 0.0;
                }
                if (s.min > s.max) {
                    double t = s.min;
                    s.min = s.max;
                    s.max = t;
                }
                if (!StringList.isEmpty(s.strings)) {
                    s.min = 0.0;
                    s.max = s.strings.count() - 1;
                }
                if (vt == 0) {
                    s.min = 0.0;
                    s.max = 1.0;
                }
                double k = 1.0;
                if (vt == 3) {
                    k = 10.0;
                }
                if (vt == 4) {
                    k = 100.0;
                }
                if (vt == 5) {
                    k = 1000.0;
                }
                buf[offset] = (byte)vt;
                Program.fillWord(Utils.Round(s.min * k), buf, offset + 1);
                Program.fillWord(Utils.Round(s.max * k), buf, offset + 3);
                this.eeprom[eep] = (byte)(s.strict ? 1 : 0);
                for (int day = 0; day < 7; ++day) {
                    int ofs = eep + 1 + 73 * day;
                    int count = s.times[day].length;
                    this.eeprom[ofs++] = (byte)count;
                    for (int j = 0; j < count; ++j) {
                        int t = s.times[day][j];
                        this.eeprom[ofs++] = (byte)(t / 100);
                        this.eeprom[ofs++] = (byte)(t % 100);
                        float v = (float)s.values[day][j];
                        int iv = Float.floatToIntBits(v);
                        if (vt == 0) {
                            iv = v == 0.0f ? 0 : 0x1000000;
                        } else if (vt == 1) {
                            iv = Math.round(v) << 16;
                        }
                        ofs = Program.fillWord32(iv, this.eeprom, ofs);
                    }
                }
            } else {
                Arrays.fill(buf, offset, offset + 5, (byte)0);
                Arrays.fill(this.eeprom, eep, eep + 512, (byte)0);
            }
            offset += 5;
            eep += 512;
        }
        return offset;
    }

    public void compileCode(ArrayList<String> code, Variable defOne, Program prg) throws SyntaxError {
        if (prg.hasSchedule()) {
            code.add("# SCHEDULES");
            for (int i = 0; i < this.items.length; ++i) {
                Schedule s = this.items[i];
                if (s.var == null) continue;
                String cmd = s.var.type == 1 ? "ScheduleB" : (s.var.type == 2 ? "ScheduleI" : "ScheduleF");
                Variable en = s.enabled != null ? s.enabled : defOne;
                Variable t = prg.RamVars.createSimpleVar("__iScheduleTmp" + i, 2, false, -1);
                code.add(cmd + " " + i + " " + en.fullName() + " " + s.var.fullName() + " " + t.fullName());
            }
        }
    }
}

