/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.AbstractRtuTransport;
import certa.modbus.client.ModbusClient;
import com.fazecast.jSerialComm.SerialPort;
import org.slf4j.LoggerFactory;

public class RtuTransportJSerialComm
extends AbstractRtuTransport {
    private final int baudRate;
    private final int dataBits;
    private final int parity;
    private final int stopBits;
    private final SerialPort port;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;

    public RtuTransportJSerialComm(String portName, int baudRate, int dataBits, int parity, int stopBits, int timeout, int pause) {
        super(timeout, pause, true, LoggerFactory.getLogger(RtuTransportJSerialComm.class));
        this.port = SerialPort.getCommPort(portName);
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.parity = parity;
        this.stopBits = stopBits == 1 ? 1 : 3;
    }

    public static String parityStr(int code) {
        return code == 0 ? "N" : (code == 1 ? "O" : (code == 2 ? "E" : "?"));
    }

    @Override
    protected synchronized boolean openPort() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.port == null || !this.port.isOpen()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Opening port: {}, {}, {}-{}-{}", this.port.getSystemPortName(), this.baudRate, this.dataBits, RtuTransportJSerialComm.parityStr(this.parity), this.stopBits);
            }
            try {
                if (!this.port.openPort()) {
                    this.log.error("openPort() failed");
                    this.close();
                    Thread.sleep(1000L);
                    return false;
                }
                if (!this.port.setComPortTimeouts(272, this.timeout, this.timeout)) {
                    this.log.error("setComPortTimeouts() failed");
                    this.close();
                    return false;
                }
                if (!this.port.setComPortParameters(this.baudRate, this.dataBits, this.stopBits, this.parity, false)) {
                    this.log.error("setComPortParameters() failed");
                    this.close();
                    return false;
                }
            }
            catch (Exception e) {
                this.close();
                this.log.error("Error opening port {}: {}", (Object)this.port.getSystemPortName(), (Object)e);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Port opened: {}", (Object)this.port.getSystemPortName());
            }
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.port != null && this.port.isOpen()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Closing port: {}", (Object)this.port.getSystemPortName());
            }
            try {
                this.port.closePort();
            }
            catch (Exception e) {
                this.log.error("Error closing port {}: {}", (Object)this.port.getSystemPortName(), (Object)e);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Port {} closed", (Object)this.port.getSystemPortName());
            }
        }
    }

    @Override
    protected void clearInput() {
        int bytes = this.port.bytesAvailable();
        while (bytes > 0) {
            int rb = this.port.readBytes(this.buffer, Math.max(bytes, this.buffer.length));
            if (rb < 0) {
                this.log.warn("readBytes() failed in clearInput()");
                return;
            }
            if (rb > 0 && this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(this.buffer, 0, rb));
            }
            bytes = this.port.bytesAvailable();
        }
    }

    @Override
    protected void sendData(int size) {
        int nb = this.port.writeBytes(this.buffer, size, 0L);
        if (nb != size) {
            this.log.warn("sendData() failed. {} from {} bytes written", (Object)nb, (Object)size);
        }
    }

    @Override
    protected boolean readToBuffer(int start, int length, ModbusClient modbusClient) throws InterruptedException {
        int res = this.port.readBytes(this.buffer, length, start);
        if (res < length) {
            if (res > 0 && this.log.isTraceEnabled()) {
                this.log.trace("Read (incomplete): " + ModbusPdu.toHex(this.buffer, 0, start + res));
            }
            this.log.warn("Response from {} timeout ({} bytes, need {})", modbusClient.getServerId(), start + res, this.expectedBytes);
            return false;
        }
        return true;
    }
}

